function generateApplicationAttributeColumnDescription(row, targetTypeMap, targetNameMap, newAttributeMappingsArray) {
    let type = "";
    let name = "";

    if (targetTypeMap.hasOwnProperty(row.target.type) && targetTypeMap[row.target.type] !== "\u200b") {
        type = targetTypeMap[row.target.type];
    }
    if (targetNameMap.hasOwnProperty(row.target.name)) {
        name = targetNameMap[row.target.name];
    } else {
        const options = _.flatten(newAttributeMappingsArray.map(function (item) {
            let array = item.options;
            array.forEach(function (i) {
                i["typeLabel"] = item.groupLabel;
            })
            return array;
        }));


        const existingMapping = _.find(options, function (item) {
            return item.value.name === row.target.name;
        });

        if (existingMapping !== undefined) {
            type = existingMapping.typeLabel;
            name = existingMapping.label;
        } else {
            name = row.target.name;
        }
    }

    return type !== "" ? type + ": " + name : name;
}