/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.spi.AbstractHTTPConnector;
import de.resolution.usersync.spi.OAuthConnectorConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthConnector<T extends OAuthConnectorConfiguration>
extends AbstractHTTPConnector<T> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthConnector.class);

    protected AbstractOAuthConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull T configuration, boolean newConnector, long lastUpdated, @Nullable String pathToAttributeMappingTemplate) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, pathToAttributeMappingTemplate);
    }

    @Override
    @Nonnull
    protected String getAuthorizationHeaderValue() {
        String accessToken = this.getConnectorStorageValue("ACCESS_TOKEN").orElse("");
        if (accessToken.isEmpty()) {
            logger.warn("Access Token is empty, Authentication will fail.");
        }
        return "Bearer " + accessToken;
    }
}

