/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.usersync.builtin.scim.rest.AbstractResource;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimErrorResponseBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ScimErrorResponseBuilder.class);
    @Nonnull
    private static final String SCHEMA = "urn:ietf:params:scim:api:messages:2.0:Error";
    @Nullable
    private String detail;
    @Nullable
    private String scimType;
    private int status;

    @Nonnull
    public ScimErrorResponseBuilder detail(@Nonnull String detail) {
        this.detail = detail;
        return this;
    }

    @Nonnull
    public ScimErrorResponseBuilder status(int status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public ScimErrorResponseBuilder status(@Nonnull Response.Status status) {
        this.status = status.getStatusCode();
        return this;
    }

    @Nonnull
    public ScimErrorResponseBuilder scimType(@Nonnull String scimType) {
        this.scimType = scimType;
        return this;
    }

    @Nonnull
    public Response build() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        ArrayNode schemas = mapper.createArrayNode();
        schemas.add(SCHEMA);
        root.set("schemas", (JsonNode)schemas);
        if (this.scimType != null) {
            root.put("scimType", this.scimType);
        }
        if (this.detail != null) {
            root.put("detail", this.detail);
        }
        root.put("status", String.valueOf(this.status));
        try {
            String body = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)root);
            logger.debug(body);
            return Response.status((int)this.status).entity((Object)body).cacheControl(AbstractResource.ccNoCache).build();
        }
        catch (IOException e) {
            logger.error("Creating response body failed.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Creating response body failed").cacheControl(AbstractResource.ccNoCache).build();
        }
    }
}

