/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.groovyconnector;

import com.atlassian.sal.api.component.ComponentLocator;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.NotImplementedException;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnectorCode;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnectorConfiguration;
import de.resolution.usersync.builtin.groovyconnector.SyncSingleUserWrapper;
import de.resolution.usersync.builtin.groovyconnector.SyncWrapper;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.spi.AbstractConnector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyConnector
extends AbstractConnector<GroovyConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(GroovyConnector.class);
    private final GroovyConnectorCode groovyCode;

    protected GroovyConnector(@Nonnull ConnectorService connectorService, @Nonnull GroovyConnectorConfiguration configuration, @Nullable GroovyConnectorCode groovyCode, @Nonnull ComponentLocator componentLocator, @Nonnull AtlasUserAdapter atlasUserAdapter, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/GroovyConnector.json");
        this.groovyCode = groovyCode;
        if (groovyCode == null) {
            logger.warn("Script is null!");
        } else {
            groovyCode.connector = this;
            groovyCode.componentLocator = componentLocator;
            groovyCode.atlasUserAdapter = atlasUserAdapter;
            groovyCode.connectorService = connectorService;
            groovyCode.init();
        }
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        if (syncStatusFacade.getSyncStatus() != null && syncStatusFacade.getSyncStatus().isSimulate()) {
            syncStatusFacade.fail("Simulation is not supported yet", logger);
            return;
        }
        if (this.groovyCode == null) {
            syncStatusFacade.fail("No script available", logger);
            return;
        }
        this.groovyCode.sync(new SyncWrapper(syncFunction, syncStatusFacade));
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, @Nullable MapStructuredData additionalData) {
        if (this.groovyCode == null) {
            return FindUserResult.failed(new NotImplementedException("No Groovy Code available"));
        }
        if (this.doesOverrideFindUserWithWrapperParameter()) {
            SyncSingleUserWrapper syncSingleUserWrapper = new SyncSingleUserWrapper(identifier, additionalData, Collections.emptyMap(), null, this.atlasUserAdapter, this.attributeTransformerMap.keySet());
            return this.groovyCode.findUser(syncSingleUserWrapper);
        }
        return this.groovyCode.findUser(identifier);
    }

    @Override
    @Nonnull
    public SyncSingleUserResult syncSingleUser(@Nonnull String identifier, @Nullable MapStructuredData auxData, @Nullable Map<String, Set<String>> attributesToOverride, @Nullable String overridingPrimaryAttribute, boolean simulate) {
        if (simulate) {
            return SyncSingleUserResult.createFailure("Simulation is not supported in Groovy Connector");
        }
        if (this.groovyCode == null) {
            return SyncSingleUserResult.createFailure("No Groovy Code available");
        }
        logger.warn("Groovy Code-class is: {}", (Object)this.groovyCode.getClass().getName());
        try {
            if (this.doesOverrideSyncSingleUserWithMapParameter()) {
                logger.warn("Groovy Connector {} implements the deprecated SyncSingleUser() method and should be updated", (Object)this.getName());
                return this.groovyCode.syncSingleUser(identifier, (Map<?, ?>)auxData, attributesToOverride);
            }
            SyncSingleUserWrapper wrapper = new SyncSingleUserWrapper(identifier, auxData, attributesToOverride, overridingPrimaryAttribute, this.atlasUserAdapter, this.attributeTransformerMap.keySet());
            return this.groovyCode.syncSingleUser(wrapper);
        }
        catch (Exception e) {
            logger.warn("Connector-Code failed", (Throwable)e);
            for (StackTraceElement traceElement : e.getStackTrace()) {
                if (!traceElement.getClassName().equals("groovy.ConnectorCode")) continue;
                return SyncSingleUserResult.createFailure("Connector code failed in method " + traceElement.getMethodName() + " line " + traceElement.getLineNumber() + ": " + e.getMessage());
            }
            return SyncSingleUserResult.createFailure("Connector-Code failed", e);
        }
    }

    @Nonnull
    public SyncSingleUserResult syncSingleUserInParent(@Nonnull String identifier, @Nullable MapStructuredData additionalData, @Nullable Map<String, Set<String>> attributesToOverride, @Nullable String overridingPrimaryAttribute) {
        return super.syncSingleUser(identifier, additionalData, attributesToOverride, overridingPrimaryAttribute, false);
    }

    @Override
    @Nonnull
    public Class<GroovyConnectorConfiguration> getConfigurationClass() {
        return GroovyConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Groovy Connector";
    }

    @Override
    @Nonnull
    public List<String> getConnectorAttributes() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public boolean isCanSync() {
        return this.doesOverrideSync();
    }

    @Override
    public boolean isCanGenerateSyncResult() {
        return this.doesOverrideSync();
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return this.doesOverrideFindUserWithWrapperParameter() || this.doesOverrideFindUserWithStringParameter() || this.doesOverrideSyncSingleUser() || this.doesOverrideSyncSingleUserWithMapParameter();
    }

    @Override
    public boolean isAllowCustomAttributeMapping() {
        return true;
    }

    @Override
    public boolean isAllowGroupConfiguration() {
        return true;
    }

    @Override
    public boolean isCanCopyUsers() {
        return false;
    }

    @Override
    public boolean isAllowSelectingFindByAttribute() {
        return true;
    }

    @Override
    public boolean isCleanupConfigurable() {
        return true;
    }

    @Override
    public boolean isHasProvisioningSettings() {
        return true;
    }

    @Override
    public boolean isSelectableDirectory() {
        return true;
    }

    @Override
    public boolean isIncludeAllDirectories() {
        return true;
    }

    private boolean doesOverrideSync() {
        if (this.groovyCode == null) {
            return false;
        }
        try {
            this.groovyCode.getClass().getDeclaredMethod("sync", SyncWrapper.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean doesOverrideSyncSingleUser() {
        if (this.groovyCode == null) {
            return false;
        }
        try {
            this.groovyCode.getClass().getDeclaredMethod("syncSingleUser", SyncSingleUserWrapper.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean doesOverrideSyncSingleUserWithMapParameter() {
        if (this.groovyCode == null) {
            return false;
        }
        try {
            this.groovyCode.getClass().getDeclaredMethod("syncSingleUser", String.class, Map.class, Map.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean doesOverrideFindUserWithStringParameter() {
        if (this.groovyCode == null) {
            return false;
        }
        try {
            this.groovyCode.getClass().getDeclaredMethod("findUser", String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean doesOverrideFindUserWithWrapperParameter() {
        if (this.groovyCode == null) {
            return false;
        }
        try {
            this.groovyCode.getClass().getDeclaredMethod("findUser", SyncSingleUserWrapper.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

