/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.websudo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.SAMLSSORuntimeException;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.websudo.WebSudoService;
import de.resolution.commons.util.StringUtil;
import de.resolution.samlauth.api.AdditionalAuthenticationData;
import de.resolution.samlauth.api.AdditionalAuthenticationService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/websudo")
public class WebSudoRestResource {
    private final AdditionalAuthenticationService additionalAuthenticationService;
    private final WebSudoService webSudoService;
    private final SamlSsoService samlSsoService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(WebSudoRestResource.class);

    @Inject
    public WebSudoRestResource(AdditionalAuthenticationService additionalAuthenticationService, WebSudoService webSudoService, SamlSsoService samlssoService) {
        this.additionalAuthenticationService = additionalAuthenticationService;
        this.webSudoService = webSudoService;
        this.samlSsoService = samlssoService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response triggerNewWebsudoAuthentication(String triggerWebSudoRequestDataString, @Context HttpServletRequest request) {
        TriggerWebSudoRequestData triggerWebSudoRequestData;
        AdditionalAuthenticationData additionalAuthenticationData = this.additionalAuthenticationService.requestAuthentication(request, "Start WebSudo session");
        try {
            triggerWebSudoRequestData = (TriggerWebSudoRequestData)this.objectMapper.readValue(triggerWebSudoRequestDataString, TriggerWebSudoRequestData.class);
        }
        catch (IOException e) {
            logger.warn("Could not parse triggerWebSudoRequestData from String {}", (Object)StringUtil.sanitize((String)triggerWebSudoRequestDataString), (Object)e);
            return Response.status((int)400).build();
        }
        String logoutUrl = this.samlSsoService.getLogoutUrl();
        if (additionalAuthenticationData.isEnabled()) {
            String afterAuthenticationUrl;
            String authenticationUrl = additionalAuthenticationData.getAuthenticationUrl();
            String webSudoDestination = triggerWebSudoRequestData.getWebSudoDestination();
            String token = this.webSudoService.createToken(additionalAuthenticationData.getStatusId());
            try {
                afterAuthenticationUrl = this.samlSsoService.getRelativeBaseUrl() + "/plugins/servlet/samlsso/websudo?token=" + token + "&webSudoDestination=" + URLEncoder.encode(webSudoDestination, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SAMLSSORuntimeException("Unsupported Encoding should never happen", e);
            }
            return Response.ok((Object)Utils.asJsonString(new TriggerWebSudoResult(true, authenticationUrl, afterAuthenticationUrl, logoutUrl))).build();
        }
        return Response.ok((Object)Utils.asJsonString(new TriggerWebSudoResult(false, null, null, logoutUrl))).build();
    }

    @JsonAutoDetect
    public static class TriggerWebSudoRequestData {
        private final String webSudoDestination;

        @JsonCreator
        public TriggerWebSudoRequestData(@JsonProperty(value="webSudoDestination") String webSudoDestination) {
            this.webSudoDestination = webSudoDestination;
        }

        public String getWebSudoDestination() {
            return this.webSudoDestination;
        }
    }

    @JsonAutoDetect
    public static class TriggerWebSudoResult {
        private final boolean enabled;
        private final String authenticationUrl;
        private final String afterAuthenticationUrl;
        private final String logoutUrl;

        public TriggerWebSudoResult(boolean enabled, @Nullable String authenticationUrl, @Nullable String afterAuthenticationUrl, @Nonnull String logoutUrl) {
            this.enabled = enabled;
            this.authenticationUrl = authenticationUrl;
            this.afterAuthenticationUrl = afterAuthenticationUrl;
            this.logoutUrl = logoutUrl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getAuthenticationUrl() {
            return this.authenticationUrl;
        }

        public String getAfterAuthenticationUrl() {
            return this.afterAuthenticationUrl;
        }

        public String getLogoutUrl() {
            return this.logoutUrl;
        }
    }
}

