/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.InvalidUrlException;
import com.resolution.atlasplugins.samlsso.servlet.ServletUtil;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class RedirectToSsoFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RedirectToSsoFilter.class);
    private static final String ALREADY_FILTERED = RedirectToSsoFilter.class.getName() + "_already_filtered";
    private final SamlSsoService samlSsoService;
    private final LicenseChecker licenseChecker;
    private final TemplateRenderer templateRenderer;

    @Inject
    public RedirectToSsoFilter(@Qualifier(value="samlSsoService") SamlSsoService samlSsoService, LicenseChecker licenseChecker, @ComponentImport TemplateRenderer templateRenderer) {
        this.samlSsoService = samlSsoService;
        this.licenseChecker = licenseChecker;
        this.templateRenderer = templateRenderer;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(req, res);
        } else {
            req.setAttribute(ALREADY_FILTERED, (Object)"yes");
            HttpServletRequest httpReq = (HttpServletRequest)req;
            try {
                String redirectDestination = this.samlSsoService.getRelativeRedirectURLForRequest(httpReq);
                if (redirectDestination == null) {
                    chain.doFilter(req, res);
                } else {
                    LicenseStatus lcheck = this.licenseChecker.checkLicense();
                    if (!lcheck.isLicensed() && lcheck.isEnforced()) {
                        logger.error("Not redirecting, license is not valid: {}", (Object)lcheck.getMessage());
                        chain.doFilter(req, res);
                    } else {
                        logger.debug("Redirecting to {}", (Object)redirectDestination);
                        HttpServletResponse httpRes = (HttpServletResponse)res;
                        httpRes.setHeader("cache-control", "no-cache, no-store, must-revalidate");
                        httpRes.sendRedirect(redirectDestination);
                    }
                }
            }
            catch (InvalidUrlException | TimeoutExceededException e) {
                logger.error("Failed to check for redirect", e);
                ServletUtil.sendErrorHelper((HttpServletResponse)res, null, null, this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), e, this.samlSsoService.getRunningConfiguration().getErrorPageTemplate(), this.templateRenderer);
            }
        }
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

