/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.validation;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.validation.CommonIdpConfigurationDataValidator;
import com.resolution.atlasplugins.samlsso.oidcandoauth.OidcAndOAuthCommonHelpers;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.usersync.api.UserSyncService;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={OidcIdpConfigurationDataValidator.class})
public class OidcIdpConfigurationDataValidator
extends CommonIdpConfigurationDataValidator<OidcIdpConfigurationData> {
    @Inject
    public OidcIdpConfigurationDataValidator(AttributeTransformationConfigValidator attributeTransformationConfigValidator, UserSyncService userSyncService) {
        super(attributeTransformationConfigValidator, userSyncService);
    }

    @Override
    public ValidationResult validate(@Nonnull OidcIdpConfigurationData oidcIdpConfigurationData, @Nonnull ConfigurationData configurationData) {
        ValidationResult result = super.validate(oidcIdpConfigurationData, configurationData);
        OidcAndOAuthCommonHelpers.validateOAuth2Basics(oidcIdpConfigurationData, configurationData, result);
        if (oidcIdpConfigurationData.fetchUserInfo) {
            if (CollectionUtil.isNullOrEmpty((Collection)oidcIdpConfigurationData.userInfoEndpoints)) {
                result.add("userInfoEndpoints", "When fetching the user info, you must provide the userInfo endpoint url");
            } else {
                result.add("userInfoEndpoints", OidcAndOAuthCommonHelpers.validateUserInfoEndpoints(oidcIdpConfigurationData));
            }
        }
        if (CollectionUtil.isNullOrEmpty((Collection)oidcIdpConfigurationData.scopes)) {
            result.add("scopes", "You must add openid at least for scopes");
        } else if (!oidcIdpConfigurationData.scopes.contains("openid")) {
            result.add("scopes", "You must add openid as the first scope!");
        }
        if (StringUtil.isNullOrEmpty((String)oidcIdpConfigurationData.issuer)) {
            result.add("issuer", "Issuer cannot be empty");
        }
        if (StringUtil.isNullOrEmpty((String)oidcIdpConfigurationData.urlForJwtKeyStore)) {
            result.add("urlForJwtKeyStore", "You must provide the url of the JWT key store");
        }
        if (StringUtil.isNullOrEmpty((String)oidcIdpConfigurationData.wellKnownUrl)) {
            result.add("wellKnownUrl", null, "While you can also add the needed urls below by hand, we recommend to add the well-known-url and using the import");
        }
        if (oidcIdpConfigurationData.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.SAML || oidcIdpConfigurationData.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.CONNECTORANDSAML) {
            result.add("userUpdateMethod", "Update from SAML (and Connector) is not available for Oidc.");
        }
        if (StringUtil.isNullOrEmpty((String)oidcIdpConfigurationData.responseMode)) {
            result.add("responseMode", "You must set a response_mode. Choose 'form_post' when in doubt");
        }
        if (!oidcIdpConfigurationData.sendAndVerifyNonce) {
            result.add("sendAndVerifyNonce", null, "Keeping this setting is usually a good idea. Disable it only if you know what you are doing.");
        }
        return result;
    }
}

