/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.legacyloader;

import com.resolution.atlasplugins.samlsso.XMLLoader;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V1SupportInfo;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V2SupportInfo;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V3SupportInfo;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V4SupportInfo;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V5SupportInfo;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V6SupportInfo;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V7SupportInfo;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedSupportInfo;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.XmlConfigurationDataLoader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportInfoLoader {
    private static final Logger logger = LoggerFactory.getLogger(SupportInfoLoader.class);
    private static final Map<Integer, Class<? extends VersionedSupportInfo>> supportInfoClasses = new HashMap<Integer, Class<? extends VersionedSupportInfo>>();

    public V7SupportInfo load(InputStream inputStream, int version) {
        if (!supportInfoClasses.containsKey(version)) {
            logger.error("Could not load support info. Invalid support info version.");
            return null;
        }
        Class<? extends VersionedSupportInfo> supportInfoClass = supportInfoClasses.get(version);
        try {
            VersionedSupportInfo parsedSupportInfo = XMLLoader.load(inputStream, supportInfoClass);
            return this.migrateToLatestVersion(parsedSupportInfo);
        }
        catch (XMLLoader.XMLLoadFailedException e) {
            logger.error("Could not parse support info", (Throwable)e);
            return null;
        }
    }

    private V7SupportInfo migrateToLatestVersion(VersionedSupportInfo supportInfo) {
        return (V7SupportInfo)this.migrate(supportInfo);
    }

    private VersionedSupportInfo migrate(VersionedSupportInfo supportInfo) {
        VersionedSupportInfo migratedSupportInfo = supportInfo.migrateToNewerModelVersion();
        if (migratedSupportInfo == null) {
            return supportInfo;
        }
        return this.migrate(migratedSupportInfo);
    }

    static {
        supportInfoClasses.put(1, V1SupportInfo.class);
        supportInfoClasses.put(2, V2SupportInfo.class);
        supportInfoClasses.put(3, V3SupportInfo.class);
        supportInfoClasses.put(4, V4SupportInfo.class);
        supportInfoClasses.put(5, V5SupportInfo.class);
        supportInfoClasses.put(6, V6SupportInfo.class);
        supportInfoClasses.put(7, V7SupportInfo.class);
    }

    @XmlRootElement
    public static class SupportInfoVersion
    implements VersionedSupportInfo {
        public XmlConfigurationDataLoader.ConfigurationDataVersion configurationData;

        @Override
        public int getConfigurationVersion() {
            return this.configurationData.version;
        }

        @Override
        public VersionedSupportInfo migrateToNewerModelVersion() {
            return null;
        }
    }
}

