/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi.oauth;

import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.HTTPWrapper;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorStorageWrapper;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.spi.oauth.OAuthFlow;
import groovy.lang.Script;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOAuthFlow
implements OAuthFlow {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthFlow.class);
    private static final Script OAUTH_RESPONSE_KEY_ACCESS_TOKEN_EXPRESSION = StructuredData.prepareFind((String)"access_token");
    private static final Script OAUTH_RESPONSE_KEY_REFRESH_TOKEN_EXPRESSION = StructuredData.prepareFind((String)"refresh_token");
    private static final Script OAUTH_RESPONSE_KEY_EXPIRES_IN_EXPRESSION = StructuredData.prepareFind((String)"expires_in");
    @Nonnull
    protected final HTTPWrapper httpWrapper;
    @Nonnull
    protected final String baseUrl;
    @Nonnull
    protected final String tokenUrl;
    @Nullable
    protected final String clientId;
    @Nullable
    protected final String clientSecret;
    @Nonnull
    protected final ConnectorStorageWrapper connectorStorageWrapper;
    @Nonnull
    private final Set<String> scope;

    protected AbstractOAuthFlow(@Nonnull HTTPWrapper httpWrapper, @Nonnull String baseUrl, @Nonnull String tokenUrl, @Nullable String clientId, @Nullable String clientSecret, @Nonnull Set<String> scope, @Nonnull ConnectorStorageWrapper connectorStorageWrapper) {
        this.httpWrapper = httpWrapper;
        this.baseUrl = baseUrl;
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.connectorStorageWrapper = connectorStorageWrapper;
    }

    @Override
    public void refreshAccessTokenIfInvalid() throws AccessTokenException {
        if (this.isStoredAccessTokenInvalid()) {
            this.refreshAccessToken();
        }
    }

    @Override
    @Nonnull
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    @Nonnull
    public Set<String> getScope() {
        return this.scope;
    }

    @Override
    public boolean reauthenticateConnector() {
        try {
            this.refreshAccessToken();
            return true;
        }
        catch (AccessTokenException e) {
            logger.error("Refreshing the access token failed", (Throwable)e);
            return false;
        }
    }

    protected void executeTokenRequest(@Nonnull Map<Object, Object> formFields) throws AccessTokenException {
        logger.debug("Requesting new Access Token from {}", (Object)this.getTokenUrl());
        ResponseWrapper responseWrapper = this.httpWrapper.postAsForm(this.tokenUrl, formFields);
        if (!responseWrapper.isSuccess()) {
            throw new AccessTokenException(responseWrapper.getCode(), "Unexpected response while fetching token: " + responseWrapper.getCode() + ": " + responseWrapper.getMessage() + ": " + responseWrapper.getBody());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("HTTP response is {}: {}", (Object)responseWrapper.getCode(), (Object)responseWrapper.getMessage());
        }
        this.updateConnectorStorage(responseWrapper);
    }

    @Nonnull
    private String redactToken(@Nonnull String token) {
        if ((token = token.trim()).length() <= 10) {
            return "<SENSIBLE_DATA_REMOVED>";
        }
        String prefix = token.substring(0, 5);
        String suffix = token.substring(token.length() - 5);
        return prefix + "..." + suffix;
    }

    private void updateConnectorStorage(@Nonnull ResponseWrapper responseWrapper) throws AccessTokenException {
        String expiresIn;
        StructuredData responseData = responseWrapper.getBodyAsStructuredData();
        String accessToken = responseData.findString(OAUTH_RESPONSE_KEY_ACCESS_TOKEN_EXPRESSION);
        if (StringUtil.isNullOrEmpty((String)accessToken)) {
            logger.warn("No access token in response");
            this.resetAuthorization();
            throw new AccessTokenException(responseWrapper.getCode(), responseWrapper.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Storing Access Token {}", (Object)this.redactToken(accessToken));
        }
        this.connectorStorageWrapper.setValue("ACCESS_TOKEN", accessToken);
        String refreshToken = responseData.findString(OAUTH_RESPONSE_KEY_REFRESH_TOKEN_EXPRESSION);
        if (!StringUtil.isNullOrEmpty((String)refreshToken)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Storing Refresh Token {}", (Object)this.redactToken(refreshToken));
            }
            this.connectorStorageWrapper.setValue("REFRESH_TOKEN", refreshToken);
        }
        if (!StringUtil.isNullOrEmpty((String)(expiresIn = responseData.findString(OAUTH_RESPONSE_KEY_EXPIRES_IN_EXPRESSION)))) {
            try {
                long expiresInLong = Long.parseLong(expiresIn);
                Instant expirationDate = Instant.now().plusSeconds(expiresInLong);
                logger.debug("Updating expiration date to {}", (Object)expirationDate);
                String expirationDateString = String.valueOf(expirationDate.toEpochMilli());
                this.connectorStorageWrapper.setValue("ACCESS_TOKEN_EXPIRY_DATE", expirationDateString);
            }
            catch (NumberFormatException e) {
                logger.debug("Could not parse expiration date {}", (Object)expiresIn);
            }
        } else {
            logger.debug("No expires_in in response, removing stored expiry date");
            this.connectorStorageWrapper.removeValue("ACCESS_TOKEN_EXPIRY_DATE");
        }
    }

    @Override
    public void resetAuthorization() {
        this.connectorStorageWrapper.removeValue("ACCESS_TOKEN");
        this.connectorStorageWrapper.removeValue("REFRESH_TOKEN");
        this.connectorStorageWrapper.removeValue("ACCESS_TOKEN_EXPIRY_DATE");
    }

    @Override
    public boolean isTokenValid(@Nonnull String token) {
        long accessTokenExpirationDate = Long.parseLong(this.connectorStorageWrapper.getValue("ACCESS_TOKEN_EXPIRY_DATE").orElse("0"));
        if (accessTokenExpirationDate > 0L) {
            Instant expirationDate = Instant.ofEpochMilli(accessTokenExpirationDate);
            return expirationDate.isAfter(Instant.now());
        }
        return false;
    }

    protected boolean isStoredAccessTokenInvalid() {
        Optional<String> optionalStoredAccessToken = this.getStoredAccessToken();
        return !optionalStoredAccessToken.filter(this::isTokenValid).isPresent();
    }

    @Nonnull
    protected Optional<String> getStoredAccessToken() {
        return this.connectorStorageWrapper.getValue("ACCESS_TOKEN");
    }
}

