/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.usersync.api.ConnectorFactoryRegistry;
import de.resolution.usersync.api.ConnectorSupportInformation;
import de.resolution.usersync.api.SupportInformationGenerator;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.impl.AoConnectorConfiguration;
import de.resolution.usersync.impl.SyncStatusAoProxy;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.java.ao.Query;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SupportInformationGenerator.class})
public class SupportInformationGeneratorImpl
implements SupportInformationGenerator {
    private final ActiveObjects ao;
    private final ConnectorFactoryRegistry connectorFactoryRegistry;
    private final SyncStatusRepository syncStatusRepository;

    @Inject
    public SupportInformationGeneratorImpl(@ComponentImport ActiveObjects ao, SyncStatusRepository syncStatusRepository, ConnectorFactoryRegistry connectorFactoryRegistry) {
        this.ao = ao;
        this.connectorFactoryRegistry = connectorFactoryRegistry;
        this.syncStatusRepository = syncStatusRepository;
    }

    @Override
    @Nullable
    public ConnectorSupportInformation generate(String uniqueId, boolean sanitize) {
        return (ConnectorSupportInformation)this.ao.executeInTransaction(() -> {
            AoConnectorConfiguration[] aoConfigs = (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class, Query.select().where("UNIQUE_ID = ?", new Object[]{uniqueId}).order("ID DESC"));
            if (aoConfigs == null || aoConfigs.length == 0) {
                return null;
            }
            return this.generate(aoConfigs[0], sanitize);
        });
    }

    @Override
    @Nonnull
    public List<ConnectorSupportInformation> generate(boolean sanitize) {
        return (List)this.ao.executeInTransaction(() -> {
            AoConnectorConfiguration[] configs = (AoConnectorConfiguration[])this.ao.find(AoConnectorConfiguration.class);
            HashMap<String, AoConnectorConfiguration> map = new HashMap<String, AoConnectorConfiguration>();
            for (AoConnectorConfiguration cfg2 : configs) {
                if (!map.containsKey(cfg2.getUniqueId())) {
                    map.put(cfg2.getUniqueId(), cfg2);
                    continue;
                }
                AoConnectorConfiguration present = (AoConnectorConfiguration)map.get(cfg2.getUniqueId());
                if (cfg2.getLastUpdated() <= present.getLastUpdated()) continue;
                map.put(cfg2.getUniqueId(), cfg2);
            }
            return map.values().stream().map(cfg -> this.generate((AoConnectorConfiguration)cfg, sanitize)).collect(Collectors.toList());
        });
    }

    private ConnectorSupportInformation generate(AoConnectorConfiguration cfg, boolean sanitize) {
        String uniqueId = cfg.getUniqueId();
        String configJson = sanitize ? cfg.getSanitizedConfigurationString() : cfg.getConfigurationString();
        String className = cfg.getClassName();
        boolean connectorAvailable = this.connectorFactoryRegistry.getConnectorFactory(className).isPresent();
        long lastUpdated = cfg.getLastUpdated();
        SyncStatusAoProxy syncStatus = this.syncStatusRepository.getLast(uniqueId);
        return new ConnectorSupportInformation(uniqueId, configJson, sanitize, className, connectorAvailable, lastUpdated, syncStatus);
    }
}

