/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api.cleanup;

import de.resolution.atlasuser.api.AtlasUserStatusObject;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserFunction;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.ExceptionToResultBuilderMapper;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.api.cleanup.CleanupDecider;
import de.resolution.usersync.api.cleanup.UserCleanup;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupFunction
extends UserCleanup
implements AtlasUserFunction {
    private static final Logger logger = LoggerFactory.getLogger(CleanupFunction.class);
    private final long minimalTimestamp;
    private final CleanupDecider cleanupDecider;
    private final int slowdownDelayInMs;

    public CleanupFunction(long minimalTimestamp, CleanupBehaviour behaviour, CleanupDecider cleanupDecider, AtlasUserAdapter atlasUserAdapter, Collection<String> knownAttributes, boolean removeAllGroupAssignmentsOnCleanup, List<String> groupsOrRegexNotBeRemoved, int slowdownDelayInMs) {
        super(behaviour, atlasUserAdapter, knownAttributes, removeAllGroupAssignmentsOnCleanup, groupsOrRegexNotBeRemoved);
        this.minimalTimestamp = minimalTimestamp;
        this.cleanupDecider = cleanupDecider;
        this.slowdownDelayInMs = slowdownDelayInMs;
    }

    public Optional<AtlasUserResult> apply(AtlasUser atlasUser, AtlasUserStatusObject atlasUserStatusObject, boolean simulate) {
        AtlasUserResult resultToReturn;
        AtlasUserResultBuilder resultBuilder = AtlasUserResult.builder((AtlasUserReference)atlasUser.getReference()).initialUser(atlasUser);
        long timestamp = Long.parseLong(atlasUser.get("ATLAS_USER_TIMESTAMP").orElse("0"));
        try {
            if (!this.cleanupDecider.shouldCleanup(atlasUser, this.minimalTimestamp)) {
                return Optional.empty();
            }
            resultToReturn = super.cleanupUser(atlasUser, resultBuilder, timestamp, simulate);
            this.slowdown();
        }
        catch (Exception e) {
            resultToReturn = ExceptionToResultBuilderMapper.map((AtlasUserResultBuilder)resultBuilder, (Exception)e).build();
        }
        atlasUserStatusObject.add(resultToReturn);
        return Optional.ofNullable(resultToReturn);
    }

    private void slowdown() {
        if (this.slowdownDelayInMs > 0) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Pausing for {}ms to reduce system load", (Object)this.slowdownDelayInMs);
                }
                Thread.sleep(this.slowdownDelayInMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class UnexpectedBehaviourException
    extends RuntimeException {
        public UnexpectedBehaviourException(CleanupBehaviour cleanupBehaviour) {
            super("Unexpected behaviour " + cleanupBehaviour.toString());
        }
    }
}

