/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.tracker.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.resolution.atlasplugins.samlsso.ReadOnlyModeDetector;
import com.resolution.atlasplugins.samlsso.SendEmailService;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.tracker.ErrorAuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.activeobjects.AoAuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.activeobjects.AuthenticationTrackerActiveObjectsProxy;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTrackerRepository;
import com.resolution.samlwrapper.api.tracker.TrackerIdGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ActiveObjectAuthenticationTrackerRepository
implements AuthenticationTrackerRepository {
    private static final Logger logger = LoggerFactory.getLogger(ActiveObjectAuthenticationTrackerRepository.class);
    private final ActiveObjects activeObjects;
    private final ActiveObjectAuthenticationTrackerRepository thisRepo;
    private final ReadOnlyModeDetector readOnlyModeDetector;
    private final SendEmailService sendEmailService;
    private boolean catchExceptions = true;
    private boolean addDebugMessages = false;

    @Inject
    public ActiveObjectAuthenticationTrackerRepository(ReadOnlyModeDetector readOnlyModeDetector, @ComponentImport ActiveObjects activeObjects, SendEmailService sendEmailService) {
        this.activeObjects = activeObjects;
        this.thisRepo = this;
        this.sendEmailService = sendEmailService;
        this.readOnlyModeDetector = readOnlyModeDetector;
    }

    public boolean isReadOnlyMode() {
        return this.readOnlyModeDetector.isReadOnlyMode();
    }

    public boolean isCatchExceptions() {
        return this.catchExceptions;
    }

    @Override
    public boolean isAddDebugMessages() {
        return this.addDebugMessages;
    }

    @Override
    public void setAddDebugMessages(boolean addDebugMessages) {
        this.addDebugMessages = addDebugMessages;
    }

    @Override
    public void setCatchExceptions(boolean catchExceptions) {
        this.catchExceptions = catchExceptions;
    }

    public AuthenticationTracker create() {
        return this.create(null);
    }

    private AuthenticationTracker create(String id) {
        try {
            return (AuthenticationTracker)this.activeObjects.executeInTransaction(() -> {
                String trackerId;
                if (id == null || id.trim().length() == 0) {
                    trackerId = TrackerIdGenerator.createId();
                    while (this.activeObjects.get(AoAuthenticationTracker.class, (Object)trackerId) != null) {
                        logger.debug("Tracker id {} is already there, creating a new one", (Object)trackerId);
                        trackerId = TrackerIdGenerator.createId();
                    }
                    logger.debug("Created new tracker id {}", (Object)trackerId);
                } else {
                    trackerId = id;
                    logger.debug("Using tracker id {}", (Object)trackerId);
                }
                long created = new Date().getTime();
                this.activeObjects.create(AoAuthenticationTracker.class, new DBParam[]{new DBParam("TRACKERID", (Object)trackerId), new DBParam("CREATED", (Object)created), new DBParam("LAST_MODIFIED", (Object)created), new DBParam("STATUS", (Object)SAMLAuthenticationTracker.Status.NEW), new DBParam("SAML_STATUS", (Object)SAMLAuthenticationTracker.SamlStatus.NEW)});
                AuthenticationTrackerActiveObjectsProxy tracker = new AuthenticationTrackerActiveObjectsProxy(trackerId, this.thisRepo);
                logger.debug("Created tracker {}", (Object)tracker);
                return tracker;
            });
        }
        catch (Exception e) {
            if (!this.catchExceptions) {
                throw new AoTrackerRepoRuntimeException(e);
            }
            return new ErrorAuthenticationTracker(e);
        }
    }

    public AuthenticationTracker get(String trackerId, boolean create) {
        if (trackerId == null || trackerId.trim().length() == 0) {
            logger.warn("Tracker Id is null or empty");
            return new ErrorAuthenticationTracker("Tracker Id is null or empty");
        }
        try {
            AoAuthenticationTracker aoTracker = (AoAuthenticationTracker)this.activeObjects.get(AoAuthenticationTracker.class, (Object)trackerId);
            if (aoTracker != null) {
                return new AuthenticationTrackerActiveObjectsProxy(trackerId, this.thisRepo);
            }
            if (create) {
                return this.create(trackerId);
            }
            return null;
        }
        catch (Exception e) {
            if (!this.catchExceptions) {
                throw new AoTrackerRepoRuntimeException(e);
            }
            return new ErrorAuthenticationTracker(e);
        }
    }

    public AuthenticationTracker getOrCreateNewTracker(@Nullable String trackerId) {
        if (trackerId == null || trackerId.isEmpty()) {
            logger.debug("trackerId is null or empty, creating new tracker");
            return this.create();
        }
        if (!this.has(trackerId)) {
            logger.debug("trackerId {} is not in repository, creating new tracker.", (Object)trackerId);
            return this.create();
        }
        return this.get(trackerId, false);
    }

    public boolean has(String trackerId) {
        try {
            AoAuthenticationTracker aoTracker = (AoAuthenticationTracker)this.activeObjects.get(AoAuthenticationTracker.class, (Object)trackerId);
            return aoTracker != null;
        }
        catch (Exception e) {
            logger.error("Something bad happended in method has()", (Throwable)e);
            return false;
        }
    }

    public AuthenticationTracker getBySamlRequestId(String requestId) {
        if (requestId == null || requestId.trim().isEmpty()) {
            return new ErrorAuthenticationTracker("SAMLRequestId is null or empty!");
        }
        try {
            AoAuthenticationTracker[] trackers = (AoAuthenticationTracker[])this.activeObjects.find(AoAuthenticationTracker.class, "SAML_REQUEST_ID = ?", new Object[]{Utils.truncate(requestId, 255)});
            if (trackers == null || trackers.length == 0) {
                return null;
            }
            String trackerId = trackers[0].getTrackerId();
            return new AuthenticationTrackerActiveObjectsProxy(trackerId, this);
        }
        catch (Exception e) {
            if (!this.catchExceptions) {
                throw new AoTrackerRepoRuntimeException(e);
            }
            return new ErrorAuthenticationTracker(e);
        }
    }

    public AuthenticationTracker getBySamlLogoutRequestId(String logoutRequestId) {
        if (logoutRequestId == null || logoutRequestId.trim().isEmpty()) {
            return new ErrorAuthenticationTracker("SAMLLogoutRequestId is null or empty!");
        }
        try {
            AoAuthenticationTracker[] trackers = (AoAuthenticationTracker[])this.activeObjects.find(AoAuthenticationTracker.class, "SAML_LOGOUT_REQUEST_ID = ?", new Object[]{Utils.truncate(logoutRequestId, 255)});
            if (trackers == null || trackers.length == 0) {
                return null;
            }
            String trackerId = trackers[0].getTrackerId();
            return new AuthenticationTrackerActiveObjectsProxy(trackerId, this);
        }
        catch (Exception e) {
            if (!this.catchExceptions) {
                throw new AoTrackerRepoRuntimeException(e);
            }
            return new ErrorAuthenticationTracker(e);
        }
    }

    public List<AuthenticationTracker> find(long fromCreated, long untilCreated, long fromLastModified, long untilLastModified, List<SAMLAuthenticationTracker.SamlStatus> samlStatuses, SAMLAuthenticationTrackerRepository.OrderBy orderBy, int offset, int count, boolean descending) {
        return this.find(fromCreated, untilCreated, fromLastModified, untilLastModified, null, samlStatuses, orderBy, offset, count, descending, "");
    }

    private Query createQuery(long fromCreated, long untilCreated, long fromLastModified, long untilLastModified, List<SAMLAuthenticationTracker.Status> statuses, List<SAMLAuthenticationTracker.SamlStatus> samlStatuses, String userIdOrTrackerId) {
        ArrayList<String> whereParts = new ArrayList<String>();
        ArrayList<Object> queryParams = new ArrayList<Object>();
        if (fromCreated > 0L) {
            whereParts.add("CREATED >= ? ");
            queryParams.add(fromCreated);
        }
        if (untilCreated > 0L) {
            whereParts.add("CREATED < ? ");
            queryParams.add(untilCreated);
        }
        if (fromLastModified > 0L) {
            whereParts.add("LAST_MODIFIED >= ? ");
            queryParams.add(fromLastModified);
        }
        if (untilLastModified > 0L) {
            whereParts.add("LAST_MODIFIED < ? ");
            queryParams.add(untilLastModified);
        }
        if (statuses != null && !(statuses = statuses.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            whereParts.add("STATUS IN ( " + Utils.join(statuses, ",", "'") + " )");
        }
        if (samlStatuses != null && !(samlStatuses = samlStatuses.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            whereParts.add("SAML_STATUS IN ( " + Utils.join(samlStatuses, ",", "'") + " )");
        }
        if (userIdOrTrackerId != null && !userIdOrTrackerId.isEmpty()) {
            whereParts.add("(USER_ID LIKE ? or TRACKERID LIKE ?)");
            queryParams.add("%" + userIdOrTrackerId + "%");
            queryParams.add("%" + userIdOrTrackerId + "%");
        }
        Query query = Query.select();
        if (!whereParts.isEmpty()) {
            String whereClauseString = Utils.join(whereParts, " AND ", null);
            query.where(whereClauseString, queryParams.toArray());
        }
        return query;
    }

    @Override
    public int count(long fromCreated, long untilCreated, long fromLastModified, long untilLastModified, List<SAMLAuthenticationTracker.Status> statuses, List<SAMLAuthenticationTracker.SamlStatus> samlStatuses, String userId) {
        Query query = this.createQuery(fromCreated, untilCreated, fromLastModified, untilLastModified, statuses, samlStatuses, userId);
        return this.activeObjects.count(AoAuthenticationTracker.class, query);
    }

    @Override
    public List<AuthenticationTracker> find(long fromCreated, long untilCreated, long fromLastModified, long untilLastModified, List<SAMLAuthenticationTracker.Status> statuses, List<SAMLAuthenticationTracker.SamlStatus> samlStatuses, SAMLAuthenticationTrackerRepository.OrderBy orderBy, int offset, int count, boolean descending, String userIdOrTrackerId) {
        try {
            Query query = this.createQuery(fromCreated, untilCreated, fromLastModified, untilLastModified, statuses, samlStatuses, userIdOrTrackerId);
            switch (orderBy) {
                case LAST_MODIFIED: {
                    query.order("LAST_MODIFIED" + (descending ? " DESC" : " ASC"));
                    break;
                }
                case CREATED: {
                    query.order("CREATED" + (descending ? " DESC" : " ASC"));
                    break;
                }
            }
            if (offset > 0) {
                query.offset(offset);
            }
            if (count > 0) {
                query.limit(count);
            }
            AoAuthenticationTracker[] trackersFound = (AoAuthenticationTracker[])this.activeObjects.find(AoAuthenticationTracker.class, query);
            logger.debug("Found {} trackers", (Object)trackersFound.length);
            ArrayList<AuthenticationTracker> ret = new ArrayList<AuthenticationTracker>();
            for (AoAuthenticationTracker aoAuthenticationTracker : trackersFound) {
                AuthenticationTrackerActiveObjectsProxy tracker = new AuthenticationTrackerActiveObjectsProxy(aoAuthenticationTracker.getTrackerId(), this);
                ret.add(tracker);
            }
            return ret;
        }
        catch (Exception e) {
            if (!this.catchExceptions) {
                throw new AoTrackerRepoRuntimeException(e);
            }
            return Collections.singletonList(new ErrorAuthenticationTracker(e));
        }
    }

    public int cleanup(long maxAgeInSeconds) {
        try {
            return (Integer)this.activeObjects.executeInTransaction(() -> {
                int deletedCount;
                if (maxAgeInSeconds > 0L) {
                    long now = new Date().getTime();
                    long deletebefore = now - maxAgeInSeconds * 1000L;
                    deletedCount = this.activeObjects.deleteWithSQL(AoAuthenticationTracker.class, "LAST_MODIFIED < ?", new Object[]{deletebefore});
                } else {
                    logger.warn("maxAgeInSeconds is {} all entries will be deleted", (Object)maxAgeInSeconds);
                    deletedCount = this.activeObjects.deleteWithSQL(AoAuthenticationTracker.class, "LAST_MODIFIED > 0", new Object[0]);
                }
                logger.debug("deleted {} Trackers", (Object)deletedCount);
                return deletedCount;
            });
        }
        catch (Exception e) {
            logger.error("Something bad happened during cleanup()", (Throwable)e);
            if (!this.catchExceptions) {
                throw new AoTrackerRepoRuntimeException(e);
            }
            return -1;
        }
    }

    public void changed(SAMLAuthenticationTracker tracker) {
    }

    protected ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public void notifiyStatusChange(AuthenticationTracker tracker) {
        if (tracker.getNotificationMail() != null) {
            String subject = "Authentication Tracker " + tracker.getTrackerId() + " status changed to " + tracker.getStatus().toString();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                ObjectWriter jsonWriter = objectMapper.writerWithDefaultPrettyPrinter();
                String body = jsonWriter.writeValueAsString((Object)tracker);
                this.sendEmailService.sendEmail(tracker.getNotificationMail(), subject, body);
            }
            catch (IOException e) {
                logger.error("Generating JSON from tracker failed", (Throwable)e);
            }
        }
    }

    public static class AoTrackerRepoRuntimeException
    extends RuntimeException {
        public AoTrackerRepoRuntimeException(Throwable cause) {
            super(cause);
        }
    }
}

