/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.samlwrapper.api.tracker.TrackerIdGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class LoggedOutPageServlet
extends BasicServlet {
    private final AuthenticationTrackerRepository trackerRepository;
    private static final long serialVersionUID = -6848231299782192696L;

    public LoggedOutPageServlet(@Nonnull SamlSsoService samlSsoComponent, @Nonnull TemplateRenderer renderer, @Nonnull AuthenticationTrackerRepository trackerRepository) {
        super(samlSsoComponent, renderer);
        this.trackerRepository = trackerRepository;
    }

    @Override
    public void processRequest(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp) throws IOException {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        if (this.samlSsoService.isLoggedInUser(req)) {
            resp.sendRedirect(this.samlSsoService.getRelativeBaseUrl());
            return;
        }
        ctx.put("loginurl", this.samlSsoService.getRelativeNossoLoginPageUrl());
        ctx.put("ssourl", this.samlSsoService.getRelativeInitiateSSOUrl());
        ArrayList<LogoutPageMessage> messages = new ArrayList<LogoutPageMessage>();
        String trackerId = req.getParameter("t");
        if (TrackerIdGenerator.isValidTrackerId((String)trackerId)) {
            ctx.put("wasSso", true);
            AuthenticationTracker tracker = (AuthenticationTracker)this.trackerRepository.get(trackerId, false);
            if (tracker != null) {
                switch (tracker.getSingleLogoutStatus()) {
                    case NONE: {
                        break;
                    }
                    case WARNING: {
                        messages.add(new LogoutPageMessage(LogoutPageMessage.MessageType.warning, "Single Logout was not successful. You may still be logged in other applications. If the problem persists, please contact your administrator and refer this id: " + trackerId));
                        break;
                    }
                    case ERROR: {
                        messages.add(new LogoutPageMessage(LogoutPageMessage.MessageType.error, "Single Logout was not successful. You may still be logged in other applications. If the problem persists, please contact your administrator and refer this id: " + trackerId));
                        break;
                    }
                    case SUCCESS: {
                        messages.add(new LogoutPageMessage(LogoutPageMessage.MessageType.success, "Single Logout was successful"));
                    }
                }
            }
        } else {
            ctx.put("wasSso", false);
        }
        ctx.put("messages", messages);
        String result = this.renderer.renderFragment(this.runningConfiguration.getLoggedOutPageTemplate(), ctx);
        resp.setContentType("text/html;charset=utf-8");
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        resp.getWriter().write(result);
    }

    public static class LogoutPageMessage {
        private final MessageType messageType;
        private final String message;

        public LogoutPageMessage(MessageType messageType, String message) {
            this.messageType = messageType;
            this.message = message;
        }

        public String getMessageType() {
            return this.messageType.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public static enum MessageType {
            info,
            error,
            warning,
            success;

        }
    }
}

