/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IdPForSelection {
    private final int idpId;
    private final int idpWeight;
    private final String ssoUrl;
    private final String name;
    private final String description;
    public static final ByWeight BY_WEIGHT = new ByWeight();
    public static final ByName BY_NAME = new ByName();

    public IdPForSelection(@Nonnull String ssoUrl, @Nonnull String name, @Nullable String description, int idpId, int idpWeight) {
        this.ssoUrl = ssoUrl;
        this.name = name;
        this.description = description == null ? "" : description;
        this.idpId = idpId;
        this.idpWeight = idpWeight;
    }

    @Nonnull
    public String getSsoUrl() {
        return this.ssoUrl;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public int getIdpId() {
        return this.idpId;
    }

    public int getIdpWeight() {
        return this.idpWeight;
    }

    public static class ByWeight
    implements Comparator<IdPForSelection> {
        @Override
        public int compare(IdPForSelection o1, IdPForSelection o2) {
            return Integer.compare(o1.getIdpWeight(), o2.getIdpWeight());
        }
    }

    public static class ByName
    implements Comparator<IdPForSelection> {
        @Override
        public int compare(IdPForSelection o1, IdPForSelection o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

