/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.privilege;

import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.reconfigure.privilege.ApplicationPermissionChecker;
import javax.inject.Inject;
import org.jetbrains.annotations.Nullable;

@ConfluenceComponent
public class ConfluencePermissionCheckerImpl
implements ApplicationPermissionChecker {
    private final UserAccessor userAccessor;
    private final ConfluenceAccessManager confluenceUserManager;

    @Inject
    public ConfluencePermissionCheckerImpl(@ConfluenceImport UserAccessor userAccessor, @ConfluenceImport ConfluenceAccessManager confluenceUserManager) {
        this.userAccessor = userAccessor;
        this.confluenceUserManager = confluenceUserManager;
    }

    @Override
    public boolean canUseApplication(@Nullable UserProfile userProfile) {
        if (userProfile == null) {
            return false;
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByKey(userProfile.getUserKey());
        return this.confluenceUserManager.getUserAccessStatus(confluenceUser).hasLicensedAccess();
    }
}

