/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.oidc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public class OidcIdpConfigurationData
extends OAuth2IdpConfigurationData {
    public String wellKnownUrl;
    public String issuer;
    public String urlForJwtKeyStore;
    public List<String> supportedSigningAlgorithms = new ArrayList<String>();
    public List<String> supportedScopes = new ArrayList<String>();
    public String responseMode;
    public boolean sendAndVerifyNonce;

    public OidcIdpConfigurationData() {
        this.protocolType = ProtocolType.OIDC;
        this.scopes = Collections.singletonList("openid");
        this.oAuthFlow = OAuthFlow.AUTHN_CODE;
        this.fetchUserInfo = false;
        this.authScheme = "Bearer";
        this.usePkce = false;
        this.responseMode = "form_post";
        this.sendAndVerifyNonce = true;
    }

    public OidcIdpConfigurationData(OidcIdpConfigurationData other) {
        super(other);
        this.wellKnownUrl = other.wellKnownUrl;
        this.issuer = other.issuer;
        this.urlForJwtKeyStore = other.urlForJwtKeyStore;
        this.supportedScopes = new ArrayList<String>(other.supportedScopes);
        this.supportedSigningAlgorithms = new ArrayList<String>(other.supportedSigningAlgorithms);
        this.responseMode = other.responseMode;
        this.idpId = this.clientId;
        this.sendAndVerifyNonce = other.sendAndVerifyNonce;
    }
}

