/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoggedInServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;

    public LoggedInServlet(@Nonnull SamlSsoService samlSsoService, @Nonnull TemplateRenderer renderer) {
        super(samlSsoService, renderer);
    }

    @Override
    public void processRequest(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp) throws IOException {
        if (!this.samlSsoService.isReady()) {
            this.sendError(resp, null, "SAML SingleSignOn is not initizalized, check the configuration", null);
            return;
        }
        if (!this.samlSsoService.isLoggedInUser(req)) {
            resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
            resp.sendRedirect(this.samlSsoService.getRelativeNossoLoginPageUrl());
        }
        HashMap<String, String> ctx = new HashMap<String, String>();
        String baseurl = this.samlSsoService.getRelativeBaseUrl();
        String logouturl = this.samlSsoService.getRelativeBaseUrl() + "/plugins/servlet/samlsso/logout";
        if (baseurl == null || baseurl.isEmpty()) {
            baseurl = "/";
        }
        ctx.put("baseurl", baseurl);
        ctx.put("logouturl", logouturl);
        String fragment = this.runningConfiguration.getLoggedInPageTemplate();
        String result = this.renderer.renderFragment(fragment, ctx);
        resp.setContentType("text/html;charset=utf-8");
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        resp.getWriter().write(result);
    }
}

