/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.MapUtil;
import de.resolution.commons.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import okhttp3.HttpUrl;
import org.springframework.stereotype.Component;

@Component
@Path(value="/idpSelectionButtons")
@AnonymousAllowed
@UnrestrictedAccess
public class IdpButtonsOnLoginPageRestResource {
    private final SamlSsoService samlSsoService;
    private final TemplateRenderer templateRenderer;

    @Inject
    public IdpButtonsOnLoginPageRestResource(SamlSsoService samlSsoService, TemplateRenderer templateRenderer) {
        this.samlSsoService = samlSsoService;
        this.templateRenderer = templateRenderer;
    }

    @POST
    @Produces(value={"application/json"})
    public Response getIdpButtonTemplate(@Context HttpServletRequest request, String postBody) throws JsonProcessingException {
        Map body = JSONUtil.deserializeMap((String)postBody, String.class, String.class);
        List labels = this.samlSsoService.getRunningConfiguration().getRunningIdPConfigurations().stream().filter(CommonRunningIdpConfiguration::shouldDisplayIdpButtonOnLoginPage).map(idp -> {
            String destination = IdpButtonsOnLoginPageRestResource.getDestination((String)body.get("currentUrlPath"), (String)body.get("currentUrlParameters"));
            HttpUrl.Builder builder = Objects.requireNonNull(HttpUrl.parse((String)this.samlSsoService.getAbsoluteSsoURL())).newBuilder().addQueryParameter("idp", idp.getId() + "");
            if (destination != null) {
                builder.addQueryParameter("redirectTo", destination);
            }
            String ssoUrl = builder.build().toString();
            if (!StringUtil.isNullOrEmpty((String)idp.getIdpButtonText())) {
                return new IdpButton(idp.getIdpButtonText(), ssoUrl);
            }
            return new IdpButton(idp.getName(), ssoUrl);
        }).collect(Collectors.toList());
        if (labels.isEmpty()) {
            return Response.ok((Object)Utils.asJson(MapUtil.of((Object)"noButtonsToDisplay", (Object)true))).cacheControl(Utils.ccNoCache).build();
        }
        String idpButtonsPageTemplate = this.samlSsoService.getRunningConfiguration().getIdpButtonsPageTemplate();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("hiMom", "Hi Mom!!");
        ctx.put("idps", labels);
        String result = this.templateRenderer.renderFragment(idpButtonsPageTemplate, ctx);
        result = Utils.unescapeHTML(result);
        return Response.ok((Object)Utils.asJson(MapUtil.of((Object)"hideLoginForm", (Object)this.samlSsoService.getRunningConfiguration().hideLoginForm(), (Object)"idpButtonsPageTemplate", (Object)result, (Object)"isNossoEnabled", (Object)this.samlSsoService.getRunningConfiguration().isNossoEnabled()))).cacheControl(Utils.ccNoCache).build();
    }

    @Nullable
    private static String getDestination(@Nullable String currentUrl, @Nullable String searchParams) {
        if (currentUrl == null || searchParams == null) {
            return null;
        }
        HttpUrl url = HttpUrl.parse((String)("http://example.com" + currentUrl + searchParams));
        if (url == null) {
            return null;
        }
        String destination = null;
        String currentUrlPath = url.encodedPath();
        if (currentUrlPath.contains("/servicedesk/customer")) {
            String currentDestination = url.queryParameter("destination");
            String[] splitted = currentUrlPath.split("servicedesk/customer");
            String strippedPath = splitted[0] + "servicedesk/customer";
            if (currentDestination != null) {
                String separator = currentDestination.startsWith("/") || strippedPath.endsWith("/") ? "" : "/";
                destination = strippedPath + separator + currentDestination;
            }
        } else {
            destination = url.queryParameter("os_destination");
        }
        return destination;
    }

    public static class IdpButton {
        private final String name;
        private final String ssoUrl;

        @JsonCreator
        IdpButton(@JsonProperty(value="name") String name, @JsonProperty(value="ssoUrl") String ssoUrl) {
            this.name = name;
            this.ssoUrl = ssoUrl;
        }

        public String getName() {
            return this.name;
        }

        public String getSsoUrl() {
            return this.ssoUrl;
        }
    }
}

