/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.userauth;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.resolution.atlasplugins.samlsso.userauth.AbstractDirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.DirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.RemoteDirectoryAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
@ExportAsService(value={DirectoryAdapter.class})
public class JiraDirectoryAdapter
extends AbstractDirectoryAdapter {
    private final GroupPickerSearchService groupPickerSearchService;
    private final EventPublisher eventPublisher;
    private static final Logger logger = LoggerFactory.getLogger(JiraDirectoryAdapter.class);

    @Inject
    public JiraDirectoryAdapter(RemoteDirectoryAdapter remoteDirectoryAdapter, @JiraImport TransactionTemplate transactionTemplate, @JiraImport DirectoryManager directoryManager, @JiraImport CrowdDirectoryService crowdDirectoryService, @JiraImport GroupPickerSearchService groupPickerSearchService, @JiraImport EventPublisher eventPublisher) {
        super(remoteDirectoryAdapter, transactionTemplate, directoryManager, crowdDirectoryService);
        this.groupPickerSearchService = groupPickerSearchService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Nonnull
    public List<String> getGroupNames() {
        return Collections.emptyList();
    }

    @Override
    public boolean groupExists(String name) {
        return this.groupPickerSearchService.getGroupByName(name) != null;
    }

    @Override
    public void publishJiraBeforeUserAuthenticateEvent(@Nonnull String username) {
        Class<?> eventToFire = null;
        try {
            eventToFire = Class.forName("com.atlassian.jira.event.user.BeforeUserAuthenticate", false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            logger.debug("Looks like the BeforeUserAuthenticate event is not present, thus not firing, bc ", (Throwable)e);
            return;
        }
        Constructor<?> cons = null;
        try {
            cons = eventToFire.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            logger.debug("Could not load constructor for BeforeUserAuthenticate event: ", (Throwable)e);
            return;
        }
        Object beforeUserAuthenticateEvent = null;
        try {
            beforeUserAuthenticateEvent = cons.newInstance(username);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.debug("Cannot call constructor on BeforeUserAuthenticateEvent because ", (Throwable)e);
            return;
        }
        this.eventPublisher.publish(beforeUserAuthenticateEvent);
        logger.debug("We have sent {}", (Object)beforeUserAuthenticateEvent.getClass().getName());
    }
}

