/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence.userauth;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.resolution.atlasplugins.samlsso.SAMLSSORuntimeException;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.AbstractRemoteDirectoryAdapter;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class ConfluenceRemoteDirectoryAdapter
extends AbstractRemoteDirectoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceRemoteDirectoryAdapter.class);
    private final AtlasUserAdapter atlasUserAdapter;
    public static final String AUTO_GROUPS_ADDED_ATTRIBUTE = "autoGroupsAdded";
    public static final String APPLY_AUTO_GROUPS_ATTRIBUTE = "crowd.sync.group.membership.after.successful.user.auth.enabled";

    @Inject
    public ConfluenceRemoteDirectoryAdapter(@ConfluenceImport DirectoryInstanceLoader directoryInstanceLoader, @ConfluenceImport CrowdService crowdService, AtlasUserAdapter atlasUserAdapter) {
        super(directoryInstanceLoader, crowdService);
        this.atlasUserAdapter = atlasUserAdapter;
    }

    @Nonnull
    public static ApplyAutoGroups readApplyAutoGroups(@Nonnull Directory directory) {
        String value = directory.getValue(APPLY_AUTO_GROUPS_ATTRIBUTE);
        if (value == null) {
            logger.info("No value for directory attribute {} on directory {}:{}, returning NEVER", new Object[]{APPLY_AUTO_GROUPS_ATTRIBUTE, directory.getId(), directory.getName()});
            return ApplyAutoGroups.NEVER;
        }
        if (value.equals("only_when_first_created")) {
            return ApplyAutoGroups.FIRST_LOGIN;
        }
        if (value.equals("true")) {
            return ApplyAutoGroups.ALWAYS;
        }
        return ApplyAutoGroups.NEVER;
    }

    @Override
    protected void assignDirectoryDefaultGroups(@Nonnull Principal principal, @Nonnull Directory directory, @Nonnull AuthenticationTracker tracker, boolean always) {
        boolean autoGroupsAdded;
        if (logger.isDebugEnabled()) {
            logger.debug("assignDirectoryDefaultGroups is called for {} in directory {}, always is {}", new Object[]{principal.getName(), directory.getId(), always});
        }
        ApplyAutoGroups applyAutoGroups = ConfluenceRemoteDirectoryAdapter.readApplyAutoGroups(directory);
        logger.debug("Applying auto-add groups for directory {} is {}.", (Object)directory.getId(), (Object)applyAutoGroups);
        if (applyAutoGroups == ApplyAutoGroups.NEVER && !always) {
            return;
        }
        AtlasUserReference reference = AtlasUserReference.create((String)"ATTR_NAME", (Object)principal.getName(), (long)directory.getId());
        AtlasUserResult findResult = this.atlasUserAdapter.readFirstUniqueUser(reference);
        Optional existingUserOpt = findResult.getResultingUser();
        if (!existingUserOpt.isPresent()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Could not find user {} in directory {}, not assigning default directory groups.", (Object)StringUtil.sanitize((String)principal.getName()), (Object)directory.getId());
            }
            return;
        }
        AtlasUser existingUser = (AtlasUser)existingUserOpt.get();
        List<String> defaultGroups = ConfluenceRemoteDirectoryAdapter.readAutoAddGroups(directory);
        Optional groupsAddedOpt = existingUser.get(AUTO_GROUPS_ADDED_ATTRIBUTE);
        boolean bl = autoGroupsAdded = groupsAddedOpt.isPresent() && Boolean.parseBoolean((String)groupsAddedOpt.get());
        if (!always && applyAutoGroups != ApplyAutoGroups.ALWAYS && autoGroupsAdded) {
            if (logger.isDebugEnabled()) {
                logger.debug("Directory default groups {} are already added to {}.", (Object)String.join((CharSequence)",", defaultGroups), (Object)StringUtil.sanitize((String)principal.getName()));
            }
            return;
        }
        HashSet<String> groups = new HashSet<String>(existingUser.getAttributeValues("ATTR_GROUPS"));
        groups.addAll(defaultGroups);
        AtlasUser userToUpdate = AtlasUser.builder().findBy(reference).with(AUTO_GROUPS_ADDED_ATTRIBUTE, true).with("ATTR_GROUPS", groups).with("ATTR_IS_IGNORE_ACTIVE_ON_UPDATE", true).build();
        AtlasUserResult updateResult = this.atlasUserAdapter.update(userToUpdate);
        if (updateResult.getOperation() == AtlasUserResult.Operation.FAILED && logger.isWarnEnabled()) {
            logger.warn("Updating directory default groups for {} failed: {}", (Object)StringUtil.sanitize((String)principal.getName()), (Object)JSONUtil.asJson((Object)updateResult));
        } else {
            logger.debug("Added directory default groups to user {}", (Object)StringUtil.sanitize((String)principal.getName()));
        }
    }

    @Override
    protected boolean isFirstLogin(Principal principal) {
        throw new SAMLSSORuntimeException("isFirsLogin() should never be called in ConfluenceRemoteDirectoryAdapter", null);
    }

    public static enum ApplyAutoGroups {
        FIRST_LOGIN,
        ALWAYS,
        NEVER;

    }
}

