/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.cleanup;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.responseidstore.ActiveObjectsResponseIdStore;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTrackerRepository;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class CleanupJobRunner
implements JobRunner,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(CleanupJobRunner.class);
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)CleanupJobRunner.class.getCanonicalName());
    private final RunningConfiguration pluginConfiguration;
    private final SAMLAuthenticationTrackerRepository<?> trackerRepository;
    private final ActiveObjectsResponseIdStore responseIdStore;
    private final SchedulerService schedulerService;

    @Inject
    public CleanupJobRunner(RunningConfiguration pluginConfiguration, SAMLAuthenticationTrackerRepository<?> trackerRepository, ActiveObjectsResponseIdStore responseIdStore, @ComponentImport SchedulerService schedulerService) {
        this.pluginConfiguration = pluginConfiguration;
        this.trackerRepository = trackerRepository;
        this.responseIdStore = responseIdStore;
        this.schedulerService = schedulerService;
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        logger.info("Created and registered CleanupJobRunner");
    }

    public void destroy() {
        logger.debug("Unregistering JobRunner {}", (Object)JOB_RUNNER_KEY);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        long start = System.currentTimeMillis();
        logger.info("Starting cleanup for Authentication Trackers and Response-Ids");
        int trackerMaxAgeInSeconds = this.pluginConfiguration.getTrackerStorageHours() * 60 * 60;
        logger.info("Starting AuthenticationTrackerRepository-cleanup, removing all trackers older than {} seconds", (Object)trackerMaxAgeInSeconds);
        int deletedTrackersCount = this.trackerRepository.cleanup((long)trackerMaxAgeInSeconds);
        logger.info("Starting ResponseId-cleanup, removing all response Ids older than {} hours", (Object)this.pluginConfiguration.getResponseIdStorageIntervalInHours());
        long responseIdStorageTimeinMilliseconds = (long)this.pluginConfiguration.getResponseIdStorageIntervalInHours() * 60L * 60L * 1000L;
        int deletedResponseIdsCount = this.responseIdStore.cleanup(responseIdStorageTimeinMilliseconds);
        logger.info("Cleanup task is done after {} ms, removed {} trackers and {} response ids", new Object[]{System.currentTimeMillis() - start, deletedTrackersCount, deletedResponseIdsCount});
        return JobRunnerResponse.success();
    }
}

