/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bamboo;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.AbstractSamlSsoService;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.cleanup.CleanupJobScheduler;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificator;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByRequestHeaderSelector;
import com.resolution.atlasplugins.samlsso.servlet.InvalidUrlException;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHook;
import com.resolution.samlwrapper.api.ResponseIDStore;
import com.resolution.samlwrapper.api.SAMLWrapper;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@BambooComponent(value="samlSsoService")
@ExportAsService(value={SamlSsoService.class})
public class BambooSamlSsoService
extends AbstractSamlSsoService {
    private static final Logger logger = LoggerFactory.getLogger(BambooSamlSsoService.class);
    private final AuthenticatorHook authenticatorHook;

    @Inject
    public BambooSamlSsoService(SAMLWrapper samlWrapper, @Qualifier(value="pluginConfiguration") RunningConfiguration pluginConfiguration, @BambooImport ApplicationProperties applicationProperties, AuthenticatorHook authenticatorHook, ClusterNotificator clusterNotificator, @BambooImport TemplateRenderer templateRenderer, ResponseIDStore responseIdStore, AuthenticationTrackerRepository trackerRepository, IdpByRequestHeaderSelector idpByRequestHeaderSelector, CleanupJobScheduler cleanupJobScheduler) {
        super(samlWrapper, pluginConfiguration, applicationProperties, clusterNotificator, templateRenderer, responseIdStore, trackerRepository, idpByRequestHeaderSelector, cleanupJobScheduler);
        this.authenticatorHook = authenticatorHook;
    }

    @Override
    protected String getRelativeDefaultLoginPageUrl() {
        int majorVersion = Utils.readMajorVersionNumber(this.applicationProperties.getVersion());
        logger.trace("Bamboo major version: {}", (Object)majorVersion);
        if (majorVersion <= 5) {
            return "/userlogin!default.action";
        }
        if (majorVersion < 10) {
            return "/userlogin!doDefault.action";
        }
        return "/userlogin.action";
    }

    @Override
    public String getRelativeNossoLoginPageUrl() {
        return this.getRelativeBaseUrl() + this.getRelativeDefaultLoginPageUrl() + "?nosso";
    }

    @Override
    public String getRelativeRedirectUrlForLogin(@Nonnull HttpServletRequest request) throws TimeoutExceededException, InvalidUrlException {
        return super.getRelativeRedirectUrlForLogin(request, this.getRelativeDefaultLoginPageUrl());
    }

    @Override
    public String getRelativeRedirectUrlForLogout(@Nonnull HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath.equals("/userLogout.action") || servletPath.equals("/logout.action")) {
            return this.getRelativeBaseUrl() + "/plugins/servlet/samlsso/logout";
        }
        return null;
    }

    @Override
    public boolean isLoggedInUser(@Nonnull HttpServletRequest httpServletRequest) {
        return this.authenticatorHook.isLoggedInUser(httpServletRequest);
    }

    @Override
    public boolean isBamboo() {
        return true;
    }
}

