/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api.cleanup;

import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.usersync.api.cleanup.CleanupDecider;
import java.time.Instant;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampBasedCleanupDecider
implements CleanupDecider {
    private static final Logger logger = LoggerFactory.getLogger(TimestampBasedCleanupDecider.class);

    @Override
    public boolean shouldCleanup(@Nonnull AtlasUser atlasUser, long syncStartedAtTimestamp) {
        long realTimestamp = Long.parseLong(atlasUser.get("ATLAS_USER_TIMESTAMP").orElse("0"));
        long simulateTimestamp = Long.parseLong(atlasUser.get("ATLAS_USER_SIMULATE_TIMESTAMP").orElse("0"));
        long timestamp = Math.max(simulateTimestamp, realTimestamp);
        if (timestamp < syncStartedAtTimestamp) {
            if (logger.isDebugEnabled()) {
                logger.debug("AtlasUser {} has timestamp {} older than {}.", new Object[]{atlasUser.getReference(), Instant.ofEpochMilli(timestamp), Instant.ofEpochMilli(syncStartedAtTimestamp)});
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("AtlasUser {} has timestamp {} newer than {}.", new Object[]{atlasUser.getReference(), Instant.ofEpochMilli(timestamp), Instant.ofEpochMilli(syncStartedAtTimestamp)});
        }
        return false;
    }
}

