/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.servlet;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.resolution.atlasplugins.samlsso.jira.RedirectServiceDeskLoginToSsoFilter;
import com.resolution.atlasplugins.samlsso.jira.servlet.RedirectServiceDeskUtil;
import de.resolution.commons.license.LicenseChecker;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class RedirectServiceDeskVisitPortalToSsoFilter
implements Filter {
    private static final String ALREADY_FILTERED = RedirectServiceDeskLoginToSsoFilter.class.getName() + "_already_filtered";
    private static final Pattern VISIT_PORTAL_PATTERN = Pattern.compile("/servicedesk/customer/portal/(\\d+)/user/visitportal");
    private static final Logger logger = LoggerFactory.getLogger(RedirectServiceDeskVisitPortalToSsoFilter.class);
    private final RedirectServiceDeskUtil redirectServicedeskUtil;
    private final LicenseChecker licenseChecker;

    @Inject
    public RedirectServiceDeskVisitPortalToSsoFilter(RedirectServiceDeskUtil redirectServicedeskUtil, LicenseChecker licenseChecker) {
        this.redirectServicedeskUtil = redirectServicedeskUtil;
        this.licenseChecker = licenseChecker;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(ALREADY_FILTERED, (Object)"yes");
        if (!this.licenseChecker.checkLicense().isLicensed()) {
            logger.debug("No license found, not redirecting to SSO");
            chain.doFilter(req, res);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String requestUri = request.getRequestURI();
        String portalId = null;
        Matcher matcher = VISIT_PORTAL_PATTERN.matcher(requestUri);
        if (matcher.matches()) {
            portalId = matcher.group(1);
        }
        if (this.redirectServicedeskUtil.shouldRedirect(portalId)) {
            String redirectTo = "/servicedesk/customer/portal/" + (portalId == null ? "" : portalId);
            response.sendRedirect(redirectTo);
        } else {
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

