/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.idpselection;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByEmailDomainSelector;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@AnonymousAllowed
@UnrestrictedAccess
@Path(value="/idpByEmail")
public class IdPSelectionByEmailResource {
    private final IdpByEmailDomainSelector idpByEmailDomainSelector;

    @Inject
    public IdPSelectionByEmailResource(IdpByEmailDomainSelector idpByEmailDomainSelector) {
        this.idpByEmailDomainSelector = idpByEmailDomainSelector;
    }

    @GET
    @Path(value="/{emailaddress}")
    @Produces(value={"application/json"})
    public Response getIdP(@PathParam(value="emailaddress") String emailaddress) throws JsonProcessingException {
        if (emailaddress != null && !emailaddress.trim().isEmpty()) {
            String emailDomain = Utils.getDomainPartFromEmailAddress(emailaddress);
            return Response.ok().entity((Object)Utils.asJson(new IdpResult(this.idpByEmailDomainSelector.selectIdpByEmailDomain(emailDomain)))).build();
        }
        return Response.ok().entity((Object)Utils.asJson(new IdpResult(0))).build();
    }

    public static class IdpResult {
        private final int idpId;

        public IdpResult(int idpId) {
            this.idpId = idpId;
        }

        public int getIdpId() {
            return this.idpId;
        }
    }
}

