/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.legacyloader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V3IdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedIdPConfiguration;
import com.resolution.samlwrapper.api.SAMLWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public class V2IdpConfiguration
implements Cloneable,
Comparable<V2IdpConfiguration>,
VersionedIdPConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(V2IdpConfiguration.class);
    public Integer id = null;
    public String name;
    public String description;
    public String postBindingURL;
    public String postBindingLogoutURL;
    public String redirectBindingURL;
    public String redirectBindingLogoutURL;
    public SAMLWrapper.Binding selectedLoginBinding = SAMLWrapper.Binding.POST;
    public SAMLWrapper.Binding selectedLogoutBinding = SAMLWrapper.Binding.POST;
    public SAMLWrapper.NameIdFormat nameIdFormatInRequest = SAMLWrapper.NameIdFormat.NONE;
    public String entityId;
    public String certificate;
    public String secondCertificate;
    public String relayStateParameterName;
    public String useridAttribute = null;
    public String fullnameAttribute = null;
    public String emailAttribute = null;
    public String groupAttribute = null;
    public String groupsForNewUsers = null;
    public String groupsForNewSdCustomers = null;
    public String emailDomains = null;
    public String requestHeader = null;
    public String requestHeaderValue = null;
    public String useridTransformationRegex;
    public String useridTransformationReplacement;
    public Long directoryIdForNewUsers;
    public boolean removeFromGroups = false;
    public boolean updateExisting = false;
    public boolean enableUserUpdate = false;
    public boolean lowercaseConvert = false;
    public boolean lowercaseConvertGroups = false;
    public boolean signRequests = false;
    public boolean enableSingleLogout = false;
    public String metadataurl;
    public String metadataxml;
    public boolean metadataignorecert;
    public boolean useMetadataxml = false;
    @XmlElementWrapper(name="idpAttributes")
    public HashMap<String, String> idpAttributes = new HashMap();
    @XmlElementWrapper(name="attributeMapping")
    public HashMap<String, String> attributeMapping = new HashMap();

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof V2IdpConfiguration)) {
            return false;
        }
        V2IdpConfiguration other = (V2IdpConfiguration)otherObject;
        Field[] fields = this.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                Object thisField = fields[i].get(this);
                Object otherField = fields[i].get(other);
                if (thisField == null && otherField != null) {
                    logger.debug("{} differs", (Object)fields[i].getName());
                    return false;
                }
                if (thisField != null && otherField == null) {
                    logger.debug("{} differs", (Object)fields[i].getName());
                    return false;
                }
                if (thisField == null || otherField == null || thisField.equals(otherField)) continue;
                logger.debug("{} differs", (Object)fields[i].getName());
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public V2IdpConfiguration clone() {
        try {
            V2IdpConfiguration ret = new V2IdpConfiguration();
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers())) continue;
                fields[i].set(ret, fields[i].get(this));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(V2IdpConfiguration other) {
        return this.id.compareTo(other.id);
    }

    @Override
    public V3IdpConfiguration migrateToNewerModelVersion() {
        V3IdpConfiguration migratedIdpConfiguration = new V3IdpConfiguration();
        migratedIdpConfiguration.id = this.id;
        migratedIdpConfiguration.weight = this.id;
        migratedIdpConfiguration.name = this.name;
        migratedIdpConfiguration.description = this.description;
        migratedIdpConfiguration.postBindingURL = this.postBindingURL;
        migratedIdpConfiguration.postBindingLogoutURL = this.postBindingLogoutURL;
        migratedIdpConfiguration.redirectBindingURL = this.redirectBindingURL;
        migratedIdpConfiguration.redirectBindingLogoutURL = this.redirectBindingLogoutURL;
        migratedIdpConfiguration.selectedLoginBinding = this.selectedLoginBinding;
        if (this.enableSingleLogout) {
            switch (this.selectedLoginBinding) {
                case POST: {
                    migratedIdpConfiguration.selectedLogoutBinding = V3IdpConfiguration.LogoutBinding.POST;
                    break;
                }
                case REDIRECT: {
                    migratedIdpConfiguration.selectedLogoutBinding = V3IdpConfiguration.LogoutBinding.REDIRECT;
                }
            }
        } else {
            migratedIdpConfiguration.selectedLogoutBinding = V3IdpConfiguration.LogoutBinding.DISABLE;
        }
        migratedIdpConfiguration.nameIdFormatInRequest = this.nameIdFormatInRequest;
        migratedIdpConfiguration.entityId = this.entityId;
        if (this.certificate != null && this.certificate.length() > 0) {
            migratedIdpConfiguration.certificates.add(this.certificate);
        }
        if (this.secondCertificate != null && this.secondCertificate.length() > 0) {
            migratedIdpConfiguration.certificates.add(this.secondCertificate);
        }
        migratedIdpConfiguration.relayStateParameterName = this.relayStateParameterName;
        migratedIdpConfiguration.useridAttribute = this.useridAttribute;
        migratedIdpConfiguration.fullnameAttribute = this.fullnameAttribute;
        migratedIdpConfiguration.emailAttribute = this.emailAttribute;
        migratedIdpConfiguration.groupAttribute = this.groupAttribute;
        migratedIdpConfiguration.additionalAttributes = new HashMap<String, String>();
        migratedIdpConfiguration.groupsForNewUsers = Utils.splitString(this.groupsForNewUsers);
        migratedIdpConfiguration.groupsForNewSdCustomers = Utils.splitString(this.groupsForNewSdCustomers);
        migratedIdpConfiguration.useridTransformationRegex = this.useridTransformationRegex;
        migratedIdpConfiguration.useridTransformationReplacement = this.useridTransformationReplacement;
        migratedIdpConfiguration.directoryIdForNewUsers = this.directoryIdForNewUsers;
        migratedIdpConfiguration.removeFromGroups = this.removeFromGroups;
        migratedIdpConfiguration.updateExisting = this.updateExisting;
        migratedIdpConfiguration.enableUserUpdate = this.enableUserUpdate;
        migratedIdpConfiguration.lowercaseConvert = this.lowercaseConvert;
        migratedIdpConfiguration.lowercaseConvertGroups = this.lowercaseConvertGroups;
        migratedIdpConfiguration.signRequests = this.signRequests;
        migratedIdpConfiguration.metadataurl = this.metadataurl;
        migratedIdpConfiguration.metadataxml = this.metadataxml;
        migratedIdpConfiguration.metadataignorecert = this.metadataignorecert;
        migratedIdpConfiguration.useMetadataxml = this.useMetadataxml;
        migratedIdpConfiguration.attributeMapping = this.attributeMapping;
        migratedIdpConfiguration.attributeMapping.putAll(this.idpAttributes);
        migratedIdpConfiguration.includeProtocolBindingInRequest = true;
        migratedIdpConfiguration.frontendId = null;
        migratedIdpConfiguration.useridMatchesNameId = !(this.useridAttribute != null && !this.useridAttribute.trim().isEmpty() || this.useridTransformationRegex != null && !this.useridTransformationRegex.trim().isEmpty() || this.lowercaseConvert);
        return migratedIdpConfiguration;
    }
}

