/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.Defaults;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.AnalyticsProvider;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.SamlRunningIdPConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.frontend.AttributeMappingTemplateProviderForMoreProtocols;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorDetector;
import de.resolution.atlasuser.impl.CrowdApiDirectoryAdapter;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.reconfigure.Utils;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.retransform.frontend.AttributeMappingUtils;
import de.resolution.usersync.api.UserSyncService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class DefaultAnalyticsProvider
implements AnalyticsProvider {
    public static final String KEY_IDP_TYPE = "idptype";
    public static final String KEY_PROTOCOL_TYPE = "protocolType";
    public static final String IS_SINGLE_LOGOUT_ENABLED = "doSingleLogout";
    private final SamlSsoService samlSsoService;
    private final AttributeMappingTemplateProviderForMoreProtocols attributeMappingTemplateProvider;
    private final UserSyncService userSyncService;
    private final AuthenticatorDetector authenticatorDetector;
    private final CrowdApiDirectoryAdapter crowdApiDirectoryAdapter;
    private final LicenseChecker licenseChecker;

    @Inject
    public DefaultAnalyticsProvider(SamlSsoService samlSsoService, AttributeMappingTemplateProviderForMoreProtocols attributeMappingTemplateProvider, UserSyncService userSyncService, AuthenticatorDetector authenticatorDetector, CrowdApiDirectoryAdapter crowdApiDirectoryAdapter, LicenseChecker licenseChecker) {
        this.samlSsoService = samlSsoService;
        this.attributeMappingTemplateProvider = attributeMappingTemplateProvider;
        this.userSyncService = userSyncService;
        this.authenticatorDetector = authenticatorDetector;
        this.crowdApiDirectoryAdapter = crowdApiDirectoryAdapter;
        this.licenseChecker = licenseChecker;
    }

    @Override
    public Map<String, Object> createAnalyticsData(int consentLevel) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        RunningConfiguration runningConfiguration = this.samlSsoService.getRunningConfiguration();
        ArrayList<HashMap<String, Object>> idps = new ArrayList<HashMap<String, Object>>();
        int howManyIdpButtonsOnLoginPage = 0;
        for (CommonRunningIdpConfiguration idpConfiguration : runningConfiguration.getRunningIdPConfigurations()) {
            HashMap<String, Object> currentIdP = new HashMap<String, Object>();
            this.addIdPData(idpConfiguration, currentIdP);
            idps.add(currentIdP);
            if (!idpConfiguration.shouldDisplayIdpButtonOnLoginPage()) continue;
            ++howManyIdpButtonsOnLoginPage;
        }
        data.put("howManyIdpButtonsOnLoginPage", howManyIdpButtonsOnLoginPage);
        data.put("hideLoginForm", this.samlSsoService.getRunningConfiguration().hideLoginForm());
        data.put("usesDenyPasswordAuthenticator", this.authenticatorDetector.isDenyPasswordAuthenticator());
        data.put("bitbucket-usesBlockPasswordAuthentication", runningConfiguration.isBlockPasswordAuthentication());
        data.put("idps-len", idps.size());
        data.put("idps", idps);
        data.put("idpSelectionMethod", runningConfiguration.getConfigurationData().idpSelectionMethod.toString());
        data.put("nonDefaultIdpByEmailPageJavaScript", !Defaults.DEFAULT_IDP_BY_EMAIL_JAVASCRIPT.equals(runningConfiguration.getIdpByEmailPageJavaScript()));
        data.put("nonDefaultIdpByEmailPageTemplate", !Defaults.DEFAULT_IDP_BY_EMAIL_PAGETEMPLATE.equals(runningConfiguration.getIdpByEmailPageTemplate()));
        data.put("nonDefaultIdpSelectionPageTemplate", !Defaults.DEFAULT_IDPSELECTIONPAGETEMPLATE.equals(runningConfiguration.getIdpSelectionPageTemplate()));
        data.put("nonDefaultLoggedInPageTemplate", !Defaults.DEFAULT_LOGGEDINPAGETEMPLATE.equals(runningConfiguration.getLoggedInPageTemplate()));
        data.put("nonDefaultLoggedOutPageTemplate", !Defaults.DEFAULT_LOGGEDOUTPAGETEMPLATE.equals(runningConfiguration.getLoggedOutPageTemplate()));
        data.put("nonDefaultErrorPageTemplate", !Defaults.DEFAULT_ERRORPAGETEMPLATE.equals(runningConfiguration.getErrorPageTemplate()));
        data.put("nonDefaultIdpButtonsPageTemplate", !Defaults.DEFAULT_IDP_BUTTONS_PAGETEMPLATE.equals(runningConfiguration.getIdpButtonsPageTemplate()));
        data.put("noSso", runningConfiguration.isNossoEnabled());
        data.put("serviceDeskLoginRedirectToSso", runningConfiguration.getRedirectServiceDeskPortals() != ConfigurationData.RedirectServiceDeskPortals.NONE);
        data.put("serviceDeskLoginRedirectMode", runningConfiguration.getRedirectServiceDeskPortals().toString());
        data.put("redirectToSso", runningConfiguration.isRedirectToSso());
        data.put("supportEntitlementNumber", this.licenseChecker.checkLicense().getSupportEntitlementNumber());
        data.put("directories", this.crowdApiDirectoryAdapter.getDirectoryAnalyticsInformation());
        data.put("shouldSendLoginHint", runningConfiguration.getRunningIdPConfigurations().stream().anyMatch(CommonRunningIdpConfiguration::shouldSendLoginHint));
        Utils.flattenAndIntegrateWithPrefix(data, "userSync", this.userSyncService.getAnalyticsData(consentLevel));
        return data;
    }

    private void addIdPData(CommonRunningIdpConfiguration idpConfiguration, Map<String, Object> data) {
        data.put(KEY_IDP_TYPE, String.valueOf((Object)idpConfiguration.getIdpType()));
        data.put(KEY_PROTOCOL_TYPE, String.valueOf((Object)idpConfiguration.getProtocolType()));
        data.put("userUpdateMethod", String.valueOf((Object)idpConfiguration.getUserUpdateMethod()));
        data.put("usesAdditionalAuthentication", idpConfiguration.isEnableAdditionalAuthentication());
        switch (idpConfiguration.getProtocolType()) {
            case SAML: {
                this.addSamlData((SamlRunningIdPConfiguration)idpConfiguration, data);
                break;
            }
            case OIDC: {
                this.addOidcData((OidcRunningIdpConfiguration)idpConfiguration, data);
                break;
            }
            case OAU2: {
                this.addOAuth2Data((OAuth2RunningIdpConfiguration)idpConfiguration, data);
                break;
            }
        }
        Utils.flattenAndIntegrateWithPrefix(data, "userLookUp", AttributeMappingUtils.getMatchingPresetsForAnalytics(Collections.singletonList(idpConfiguration.getUserLookUpTransformationConfig()), String.valueOf((Object)idpConfiguration.getIdpType()), this.attributeMappingTemplateProvider.getTemplates(idpConfiguration.getProtocolType())));
        Utils.flattenAndIntegrateWithPrefix(data, "userSyncLookUp", AttributeMappingUtils.getMatchingPresetsForAnalytics(Collections.singletonList(idpConfiguration.getUserSyncLookupTransformationConfig()), String.valueOf((Object)idpConfiguration.getIdpType()), this.attributeMappingTemplateProvider.getTemplates(idpConfiguration.getProtocolType())));
    }

    private void addSamlData(SamlRunningIdPConfiguration idPConfiguration, Map<String, Object> data) {
        data.put("loginBinding", String.valueOf(idPConfiguration.getSelectedLoginBinding()));
        data.put("logoutBinding", String.valueOf(idPConfiguration.getSelectedLogoutBinding()));
        data.put("groupCreationEnabled", idPConfiguration.isAddNonExistingGroups());
        data.put("assignDefaultGroups", !idPConfiguration.getDefaultUserGroups().isEmpty());
        data.put("separateRequestUrl", idPConfiguration.getRequestUrlOverride() != null && !idPConfiguration.getRequestUrlOverride().isEmpty());
        if (this.samlSsoService.isJiraServiceDesk()) {
            data.put("assignDefaultGroupsServiceDesk", !idPConfiguration.getDefaultSDCustomerGroups().isEmpty());
            data.put("organizationCreationEnabled", !idPConfiguration.isAddNonExistingOrganizations());
        }
        Map<String, Object> attributeMappingsForAnalytics = AttributeMappingUtils.getMatchingPresetsForAnalytics(idPConfiguration.getAttributeTransformationConfigs(), String.valueOf((Object)idPConfiguration.getIdpType()), this.attributeMappingTemplateProvider.getTemplates(idPConfiguration.getProtocolType()));
        for (Target.Type type : Target.Type.values()) {
            data.put("attrMapping-" + type.toString() + "-len", attributeMappingsForAnalytics.entrySet().stream().filter(stringObjectEntry -> ((String)stringObjectEntry.getKey()).startsWith(type.toString())).count());
        }
        data.put("attrMapping-len", attributeMappingsForAnalytics.size());
        Utils.flattenAndIntegrateWithPrefix(data, "attrMapping", attributeMappingsForAnalytics);
        data.put(IS_SINGLE_LOGOUT_ENABLED, idPConfiguration.isSingleLoutoutEnabled());
        data.put("usesMetadataXml", idPConfiguration.isUsingMetadataXml());
        data.put("metadataAutoReloadEnabled", idPConfiguration.isMetadataAutoReloadEnabled());
        data.put("samlUsesToLowerCaseTransformation", idPConfiguration.getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().isToLowerCase()));
        data.put("samlUsesSplitTransformation", idPConfiguration.getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getSplitAttribute().isEnabled()));
        data.put("samlUsesAddConstantTransformation", idPConfiguration.getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getAddConstant().isEnabled()));
        data.put("samlUsesRegexAndReplacementTransformation", idPConfiguration.getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getRegexAndReplacement().isEnabled()));
        data.put("samlIsGroovySourceType", idPConfiguration.getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.GROOVY)));
        data.put("samlIsFirstSourceType", idPConfiguration.getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.FIRST)));
        data.put("samlIsFieldcombinerSourceType", idPConfiguration.getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.FIELD_COMBINER)));
    }

    private void addOidcData(OidcRunningIdpConfiguration idPConfiguration, Map<String, Object> data) {
        data.put("usesWellKnownUrl", idPConfiguration.getWellKnownUrl() != null);
        data.put("fetchUserInfoWithAccessToken", idPConfiguration.isFetchUserInfo());
        data.put(IS_SINGLE_LOGOUT_ENABLED, idPConfiguration.isSingleLoutoutEnabled());
    }

    private void addOAuth2Data(OAuth2RunningIdpConfiguration idPConfiguration, Map<String, Object> data) {
        data.put(IS_SINGLE_LOGOUT_ENABLED, idPConfiguration.isSingleLoutoutEnabled());
    }
}

