AJS.$(function () {
    function waitForAndModifyLoginForm(selector) {
        console.debug('SAML SSO: Dashboard detected, waiting for login gadget or login page ' +
            'to load to inject IdP buttons');

        AJS.$.ajax({
            url: AJS.contextPath() + '/rest/samlsso-admin/1.0/idpSelectionButtons',
            type: "POST",
            contentType: "application/json", // Set the content type to JSON
            data: JSON.stringify({ // Convert the data object to a JSON string
                currentUrlPath: window.location.pathname,
                currentUrlParameters: window.location.search
            }),
            dataType: "json",
            success: function (data) {
                if (data === null) {
                    console.error("Did not get a successful response. Cannot continue")
                    return
                }

                const noButtonsToDisplay = data.noButtonsToDisplay

                if (noButtonsToDisplay === true) {
                    // no buttons should be displayed
                    return
                }

                const textToDisplay = data.idpButtonsPageTemplate
                const isNossoEnabled = data.isNossoEnabled
                const hideLoginForm = data.hideLoginForm

                let retries = 10;

                const f = function () {
                    if (!modifyLoginForm(selector, textToDisplay, isNossoEnabled, hideLoginForm) && retries >= 0) {
                        retries -= 1;
                        setTimeout(f, 1);
                    }
                };

                setTimeout(f, 1);
            },
            error: function (error) {
                console.error("SAML SSO: Call to our backend did fail. This could mean a problem on our side or" +
                    " an issue on your side to connect to the backend. Do you may use an application firewall that " +
                    "blocks our REST requests?")
                console.error(error)
            }
        });
    }

    function modifyLoginForm(selector, renderedTextToDisplay, isNossoEnabled, hideLoginForm) {
        const $loginForm = $(selector);
        if (!$loginForm.length || ( $loginForm.attr('action') && $loginForm.attr('action').indexOf('WebSudo') !== -1 )
        ) {
            console.debug('SAML SSO: Did not find a login form');
            return false;
        }

        if (hideLoginForm === true &&
            (isNossoEnabled === false || new URLSearchParams(window.location.search).get("nosso") === null)) {
            $loginForm.hide();
        }

        const injectionPointForButtonsAndText = $loginForm.parent();

        injectionPointForButtonsAndText.append('<div style="overflow: auto;">' + renderedTextToDisplay + '</div>');

        if ($loginForm.attr('id') === 'loginform') {
            // in case on dashboard resize login gadget
            injectionPointForButtonsAndText.parent().css('height', 'auto');
        }

        return true;
    }

    (function () {
        let selectorForLoginForm = ""

        if (window.location.pathname.endsWith("Dashboard.jspa") || window.location.pathname.endsWith("login.jsp")
            || window.location.pathname.includes("servicedesk")) {
            // jira
            selectorForLoginForm = "#login-form, #loginform, #form-crowd-login"
        } else if (window.location.pathname.endsWith("login.action")) {
            // confluence
            selectorForLoginForm = "form.login-form-container, #login-form"
        } else if (window.location.pathname.endsWith("login")) {
            // bitbucket
            selectorForLoginForm = ".aui, .top-label, .prevent-double-submit, #login-form, #loginform, #form-crowd-login "
        } else if (window.location.pathname.endsWith("userlogin!doDefault.action")) {
            // bamboo
            selectorForLoginForm = "#loginForm"
        }

        if (selectorForLoginForm !== "") {
            waitForAndModifyLoginForm(selectorForLoginForm)
        }
    })();
});
