/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.disableInactive;

import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.builtin.disableInactive.DisableInactiveConnectorConfiguration;
import de.resolution.usersync.builtin.disableInactive.DisableInactiveUsersConnector;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class DisableInactiveConnectorConfigurationImpl
extends AbstractConnectorConfigurationImpl
implements DisableInactiveConnectorConfiguration {
    @Nonnull
    private String maxDurationSinceLastLogin = "30";
    private boolean disableUsersWithoutTimestamp = false;
    private boolean disableByLastLoginEnabled = true;
    @Nonnull
    private List<String> groupWhitelist = Collections.emptyList();
    @Nonnull
    private List<String> groupsToDisable = Collections.emptyList();

    public DisableInactiveConnectorConfigurationImpl() {
    }

    public DisableInactiveConnectorConfigurationImpl(DisableInactiveConnectorConfiguration other) {
        super(other);
        this.setDisableUsersWithoutTimestamp(other.isDisableUsersWithoutTimestamp());
        this.setMaxDurationSinceLastLogin(other.getMaxDurationSinceLastLogin());
        this.setGroupWhitelist(other.getGroupWhitelist());
        this.setDisableByLastLoginEnabled(other.isDisableByLastLoginEnabled());
    }

    @Override
    @Nonnull
    public String getMaxDurationSinceLastLogin() {
        return this.maxDurationSinceLastLogin;
    }

    public void setMaxDurationSinceLastLogin(String maxDurationSinceLastLogin) {
        if (maxDurationSinceLastLogin != null) {
            this.maxDurationSinceLastLogin = maxDurationSinceLastLogin;
        }
    }

    @Override
    @Nonnull
    public List<String> getGroupWhitelist() {
        return this.groupWhitelist;
    }

    public void setGroupWhitelist(@Nonnull List<String> groupWhitelist) {
        this.groupWhitelist = new ArrayList<String>(groupWhitelist);
    }

    @Override
    public boolean isDisableUsersWithoutTimestamp() {
        return this.disableUsersWithoutTimestamp;
    }

    public void setDisableUsersWithoutTimestamp(boolean disableUsersWithoutTimestamp) {
        this.disableUsersWithoutTimestamp = disableUsersWithoutTimestamp;
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return "NONE";
    }

    @Override
    @Nonnull
    public ConnectorConfiguration sanitize() {
        return this;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return DisableInactiveUsersConnector.class;
    }

    @Override
    public boolean isDisableByLastLoginEnabled() {
        return this.disableByLastLoginEnabled;
    }

    public void setDisableByLastLoginEnabled(boolean disableByLastLoginEnabled) {
        this.disableByLastLoginEnabled = disableByLastLoginEnabled;
    }

    @Override
    @Nonnull
    public List<String> getGroupsToDisable() {
        return this.groupsToDisable;
    }

    public void setGroupsToDisable(@Nonnull List<String> groupsToDisable) {
        this.groupsToDisable = new ArrayList<String>(groupsToDisable);
    }
}

