/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.responseidstore;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.resolution.atlasplugins.samlsso.responseidstore.AoStoredResponseId;
import com.resolution.samlwrapper.api.ResponseIDStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import net.java.ao.DBParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ActiveObjectsResponseIdStore.class, ResponseIDStore.class})
public class ActiveObjectsResponseIdStore
implements ResponseIDStore {
    private static final Logger logger = LoggerFactory.getLogger(ActiveObjectsResponseIdStore.class);
    private final ActiveObjects activeObjects;
    public static final int STRING_LENGTH = 255;

    @Inject
    public ActiveObjectsResponseIdStore(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public boolean contains(String id) {
        String idForDatabase;
        if (id == null || id.trim().isEmpty()) {
            logger.error("ID is null or empty, returning false");
            return false;
        }
        if (id.length() > 255) {
            idForDatabase = id.substring(0, 254);
            logger.warn("Truncating request id {} to {} because it exceeds {} characters", new Object[]{id, 255, 255});
        } else {
            idForDatabase = id;
        }
        try {
            AoStoredResponseId result = (AoStoredResponseId)this.activeObjects.get(AoStoredResponseId.class, (Object)idForDatabase);
            return result != null;
        }
        catch (Exception e) {
            logger.error("Checking ActiveObjectsResponseIdStore for id {} failed, returning false", (Object)idForDatabase, (Object)e);
            return false;
        }
    }

    public void add(String id) {
        if (id == null || id.trim().isEmpty()) {
            logger.error("ID is null or empty, not adding it");
            return;
        }
        try {
            this.activeObjects.executeInTransaction(() -> {
                String idForDatabase;
                long created = new Date().getTime();
                if (id.length() > 255) {
                    idForDatabase = id.substring(0, 254);
                    logger.warn("Truncating request id {} to {} because it exceeds {} characters", new Object[]{id, 255, 255});
                } else {
                    idForDatabase = id;
                }
                this.activeObjects.create(AoStoredResponseId.class, new DBParam[]{new DBParam("RESPONSEID", (Object)idForDatabase), new DBParam("CREATED", (Object)created)});
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Adding id {} to ActiveObjectsResponseIdStore failed", (Object)id, (Object)e);
        }
    }

    public Collection<String> getIds() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            AoStoredResponseId[] responseIds;
            for (AoStoredResponseId responseId : responseIds = (AoStoredResponseId[])this.activeObjects.find(AoStoredResponseId.class)) {
                ret.add(responseId.getResponseId());
            }
        }
        catch (Exception e) {
            logger.error("Retrieving Ids from ActiveObjectsResponseIdStore failed, returning empty Collection", (Throwable)e);
        }
        return ret;
    }

    public int cleanup(long maxAgeInMilliseconds) {
        long now = new Date().getTime();
        long maxCreated = now - maxAgeInMilliseconds;
        logger.debug("Max age is {} ms, now is {}, maxCreated is {}", new Object[]{maxAgeInMilliseconds, now, maxCreated});
        try {
            return (Integer)this.activeObjects.executeInTransaction(() -> {
                int count = this.activeObjects.deleteWithSQL(AoStoredResponseId.class, "CREATED < ?", new Object[]{maxCreated});
                logger.debug("Deleted {} outdated response ids", (Object)count);
                return count;
            });
        }
        catch (Exception e) {
            logger.error("Cleaning up ActiveObjectsResponseIdStore failed", (Throwable)e);
            return -1;
        }
    }
}

