/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MultiIdPMetadataMergeResult;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MultiMetadataStatus {
    private final String message;
    private final List<String> changedIds;
    private final List<String> addedIds;
    private final List<String> removedIds;
    private final long lastUpdated;
    private final boolean success;

    @JsonCreator
    public MultiMetadataStatus(@JsonProperty(value="success") boolean success, @JsonProperty(value="message") String message, @JsonProperty(value="changedIds") List<String> changedIds, @JsonProperty(value="addedIds") List<String> addedIds, @JsonProperty(value="removedIds") List<String> removedIds, @JsonProperty(value="lastUpdated") long lastUpdated) {
        this.success = success;
        this.message = message;
        this.changedIds = new ArrayList<String>(changedIds);
        this.addedIds = new ArrayList<String>(addedIds);
        this.removedIds = new ArrayList<String>(removedIds);
        this.lastUpdated = lastUpdated;
    }

    public MultiMetadataStatus(MultiIdPMetadataMergeResult mergeResult) {
        this(mergeResult.isSuccess(), mergeResult.getMessage(), mergeResult.getChangedIds(), mergeResult.getAddedIds(), mergeResult.getRemovedIds(), Instant.now().toEpochMilli());
    }

    public MultiMetadataStatus(@Nonnull MultiMetadataStatus other) {
        this(other.isSuccess(), other.getMessage(), other.getChangedIds(), other.getAddedIds(), other.getRemovedIds(), other.getLastUpdated());
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getChangedIds() {
        return this.changedIds;
    }

    public List<String> getAddedIds() {
        return this.addedIds;
    }

    public List<String> getRemovedIds() {
        return this.removedIds;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public String getLastUpdatedUTC() {
        return DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(this.lastUpdated));
    }

    public boolean isChanged() {
        return !this.changedIds.isEmpty() || !this.addedIds.isEmpty() || !this.removedIds.isEmpty();
    }

    public boolean isSuccess() {
        return this.success;
    }
}

