/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent(value="SSOTokenStore")
public class SSOTokenStore {
    private static final Logger logger = LoggerFactory.getLogger(SSOTokenStore.class);
    private static final SSOTokenStore instance = new SSOTokenStore();
    public static final long DEFAULT_VALID_TIME = 86400000L;
    private long validTime = 86400000L;
    private final SecureRandom random = new SecureRandom();
    private final Map<String, UserWithTimestamp> tokenStore = new ConcurrentHashMap<String, UserWithTimestamp>();

    private SSOTokenStore() {
    }

    public void setValidTime(long validTime) {
        this.validTime = validTime;
    }

    public static SSOTokenStore getInstance() {
        return instance;
    }

    public String getUseridFromSsoToken(String ssotoken) {
        this.cleanup();
        UserWithTimestamp ut = this.tokenStore.remove(ssotoken);
        if (ut == null) {
            return null;
        }
        if (this.isValid(ut)) {
            return ut.getUserid();
        }
        logger.warn("SSOToken {} for user {} is expired", (Object)ssotoken, (Object)ut.getUserid());
        return null;
    }

    public boolean isValid(UserWithTimestamp ut) {
        return ut != null && ut.created + this.validTime > new Date().getTime();
    }

    public String getSsoToken(String userid) {
        this.cleanup();
        String identifier = new BigInteger(130, this.random).toString(32);
        this.tokenStore.put(identifier, new UserWithTimestamp(userid));
        return identifier;
    }

    private void cleanup() {
        int count = 0;
        for (Map.Entry<String, UserWithTimestamp> entry : this.tokenStore.entrySet()) {
            UserWithTimestamp ut = entry.getValue();
            if (ut == null || this.isValid(ut)) continue;
            this.tokenStore.remove(entry.getKey());
            ++count;
        }
        if (count > 0) {
            logger.info("Removed {} expired tokens from token store", (Object)count);
        }
    }

    public int size() {
        return this.tokenStore.size();
    }

    public static class UserWithTimestamp {
        private final String userid;
        private final long created;

        public UserWithTimestamp(String userid) {
            this.userid = userid;
            this.created = new Date().getTime();
        }

        public String getUserid() {
            return this.userid;
        }

        public long getCreated() {
            return this.created;
        }
    }
}

