/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.AbstractLogoutHander;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent
public class BitbucketLogoutHandler
extends AbstractLogoutHander {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketLogoutHandler.class);

    @Inject
    public BitbucketLogoutHandler(SamlSsoService samlssoService, RunningConfiguration pluginConfiguration) {
        super(samlssoService, pluginConfiguration);
    }

    @Override
    protected void doLogout(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, @Nonnull AuthenticationTracker tracker) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            logger.info("Handle logout, removing attribute from session.");
            if (session.getAttribute("ssoAuthenticated") != null) {
                session.setAttribute("ssoAuthenticated", (Object)"false");
            }
            tracker.setStatus(SAMLAuthenticationTracker.Status.LOGGED_OUT);
        }
    }

    @Override
    public void showLoggedOutPage(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, @Nonnull SAMLAuthenticationTracker tracker) throws IOException {
        boolean redirect;
        HttpSession session = req.getSession(false);
        boolean isSSO = false;
        if (session != null) {
            isSSO = session.getAttribute("ssoAuthenticated") != null;
        }
        switch (this.pluginConfiguration.getOverrideLoggedOutUrlMethod()) {
            case REDIRECT_ALL: {
                redirect = true;
                break;
            }
            case REDIRECT_SSO_ONLY: {
                redirect = isSSO;
                break;
            }
            default: {
                redirect = false;
            }
        }
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        if (redirect) {
            if (this.pluginConfiguration.getLogoutUrl() != null) {
                logger.debug("Redirecting to {}", (Object)this.pluginConfiguration.getLogoutUrl());
                resp.sendRedirect(this.pluginConfiguration.getLogoutUrl());
            } else {
                String loggedOutPageUrl = this.samlSsoService.getRelativeLoggedOutPageUrl();
                logger.debug("Redirecting to {}", (Object)loggedOutPageUrl);
                resp.sendRedirect(loggedOutPageUrl);
            }
        } else {
            logger.debug("Not sending redirect after handling logout.");
        }
    }
}

