function addMappingsForProfilePictures(fetchProfilePicture, mapping, mappingTemplates) {
    if (fetchProfilePicture) {

        // if profile picture data mapping not set, add it
        if (_.find(mapping, function (e) {
            return e.target.type === 'SYSTEM' && e.target.name === 'ATTR_PROFILE_PICTURE_DATA'
        }) === undefined) {
            // load preset from mapping templates
            const preset = _.get(mappingTemplates, "SYSTEM.ATTR_PROFILE_PICTURE_DATA[0].value")

            if (preset !== undefined) {
                mapping.push(
                    preset
                )
            } else {
                console.error("Preset for ATTR_PROFILE_PICTURE_DATA does not exist")
            }
        }
    }

    return mapping
}
