/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.testconnector;

import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.impl.SimpleCancelHandle;
import de.resolution.commons.data.ListStructuredData;
import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.builtin.testconnector.TestConnectorConfiguration;
import de.resolution.usersync.builtin.testconnector.TestUserCreator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@Path(value="/testdata")
public class TestConnectorRestResource {
    private final PrivilegeChecker privilegeChecker;

    @Inject
    public TestConnectorRestResource(PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @Path(value="/")
    public Response createTestdata(String testConnectorConfigurationJson, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        TestConnectorConfiguration testConnectorConfiguration = (TestConnectorConfiguration)JSONUtil.fromJson((String)testConnectorConfigurationJson, TestConnectorConfiguration.class);
        ListStructuredData testdata = TestUserCreator.createFakeUsers(testConnectorConfiguration.getCount(), testConnectorConfiguration.getGroupCount(), testConnectorConfiguration.getEmailDomain(), (CancelHandle)new SimpleCancelHandle());
        return Response.ok().entity((Object)JSONUtil.asJson((Object)testdata)).build();
    }
}

