/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.cronexpressionrest;

import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.parser.CronExpressionParser;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.rule.CronExpression;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.rule.DateTimeTemplate;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.cron.CronSyntaxException;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.springframework.stereotype.Component;

@Component
public class StandaloneCronExpressionValidator
implements CronExpressionValidator {
    @Override
    public boolean isValid(String cronExpression) {
        return CronExpressionParser.isValid(cronExpression);
    }

    @Override
    public long getNextScheduledSyncAsLong(String cronString) {
        try {
            CronExpression cron = CronExpressionParser.parse(cronString);
            TimeZone timeZone = TimeZone.getDefault();
            DateTimeTemplate when = new DateTimeTemplate(new Date(), timeZone.toZoneId());
            if (cron.next(when)) {
                ZonedDateTime zonedDateTime = Objects.requireNonNull(when.toZonedDateTime());
                return zonedDateTime.toInstant().toEpochMilli();
            }
            return -1L;
        }
        catch (CronSyntaxException e) {
            return -1L;
        }
    }
}

