/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.servlet.ServletUtil;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;

public abstract class BasicServlet
extends HttpServlet {
    protected final SamlSsoService samlSsoService;
    protected final RunningConfiguration runningConfiguration;
    protected final TemplateRenderer renderer;
    private static final long serialVersionUID = 5671437898336110647L;

    protected BasicServlet(SamlSsoService samlSsoService, TemplateRenderer renderer) {
        this.samlSsoService = samlSsoService;
        this.runningConfiguration = samlSsoService.getRunningConfiguration();
        this.renderer = renderer;
    }

    public abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected void sendGeneralError(HttpServletResponse response, int statusCode, String message) throws IOException {
        this.sendGeneralError(response, statusCode, message, null);
    }

    protected void sendGeneralError(HttpServletResponse response, int statusCode, String message, Throwable throwable) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(statusCode);
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("message", message);
        if (throwable != null) {
            ctx.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)throwable));
        }
        this.renderer.render("web/generalError/generalError.vm", ctx, (Writer)response.getWriter());
    }

    protected void sendError(@Nonnull HttpServletResponse resp, @Nullable String userid, @Nullable String message, @Nullable Throwable throwable) throws IOException {
        this.sendError(resp, userid, message, null, throwable);
    }

    protected void sendError(@Nonnull HttpServletResponse resp, @Nullable String userid, @Nullable String message, @Nullable String statusMessage, @Nullable Throwable throwable) throws IOException {
        ServletUtil.sendErrorHelper(resp, userid, message, statusMessage, this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), throwable, this.runningConfiguration.getErrorPageTemplate(), this.renderer);
    }

    protected void sendErrorWithTracker(HttpServletResponse resp, String userid, String message, AuthenticationTracker tracker) throws IOException {
        ServletUtil.sendErrorHelper(resp, userid, message, this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), tracker, this.runningConfiguration.getErrorPageTemplate(), this.renderer);
    }

    protected void sendServiceDeskError(HttpServletResponse resp, String message) throws IOException {
        String fragment = this.runningConfiguration.getServiceDeskErrorPageTemplate();
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("loginurl", this.samlSsoService.getRelativeBaseUrl() + "/servicedesk/customer/user/login?nosso");
        ctx.put("ssourl", this.samlSsoService.getRelativeInitiateSSOUrl());
        ctx.put("message", message);
        resp.setContentType("text/html;charset=utf-8");
        String result = this.renderer.renderFragment(fragment, ctx);
        resp.getWriter().write(result);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }
}

