/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.AbstractOAuthConnector;
import de.resolution.usersync.spi.OAuthConnectorConfiguration;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthClientCredentialsConnector<T extends OAuthConnectorConfiguration>
extends AbstractOAuthConnector<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthClientCredentialsConnector.class);

    protected AbstractOAuthClientCredentialsConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull T configuration, boolean newConnector, long lastUpdated, String pathToAttributeMappingTemplate) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, pathToAttributeMappingTemplate);
    }

    @Override
    protected void refreshAccessToken() throws AccessTokenException {
        if (StringUtil.isNullOrEmpty((String)((OAuthConnectorConfiguration)this.configuration).getClientId()) || StringUtil.isNullOrEmpty((String)((OAuthConnectorConfiguration)this.configuration).getClientSecret())) {
            throw new AccessTokenException("Incomplete configuration, cannot request access token.");
        }
        HashMap<Object, Object> formData = new HashMap<Object, Object>();
        formData.put("client_id", ((OAuthConnectorConfiguration)this.configuration).getClientId());
        formData.put("client_secret", ((OAuthConnectorConfiguration)this.configuration).getClientSecret());
        formData.put("grant_type", "client_credentials");
        this.getScope().ifPresent(scope -> formData.put("scope", scope));
        this.executeTokenRequest(formData);
    }

    @Override
    protected boolean isTokenValid(@Nonnull String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            Date expiresAt = jwt.getExpiresAt();
            return expiresAt != null && expiresAt.after(new Date());
        }
        catch (JWTDecodeException exception) {
            logger.debug("JWT validation of access token failed. The token may is not a JWT thus calling super method for validation", (Throwable)exception);
            return super.isTokenValid(token);
        }
    }

    @Nonnull
    protected ConnectionTestResultEntity.EndpointResult doAccessTokenConnectionTest() {
        this.resetAuthorization();
        try {
            this.refreshAccessToken();
        }
        catch (AccessTokenException ex) {
            return ConnectionTestResultEntity.EndpointResult.createError("Fetch Access Token", this.getTokenUrl(), false, ex.getStatusCode() + "", ex.getMessage(), "Please check the details below");
        }
        return ConnectionTestResultEntity.EndpointResult.create("Fetch Access Token", this.getTokenUrl(), true, "OK", null);
    }
}

