/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.impl.UnavailableConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnector;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnavailableConnector
extends AbstractConnector<UnavailableConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(UnavailableConnector.class);

    public UnavailableConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull UnavailableConnectorConfiguration defaultConfiguration) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, defaultConfiguration, false, 0L, null);
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        syncStatusFacade.fail("Sync is not possible with the UnavailableConnector", logger);
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        return FindUserResult.notFound();
    }

    @Override
    @Nonnull
    public Class<UnavailableConnectorConfiguration> getConfigurationClass() {
        return UnavailableConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Unavailable";
    }

    @Override
    @Nonnull
    public List<String> getConnectorAttributes() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return false;
    }

    @Override
    public boolean isCanSync() {
        return false;
    }

    @Override
    public boolean isCanGenerateSyncResult() {
        return false;
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return false;
    }

    @Override
    public boolean isEditable() {
        return false;
    }
}

