/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.azure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.resolution.commons.util.Elvis;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.builtin.azure.AzureConnector;
import de.resolution.usersync.builtin.azure.AzureConnectorConfiguration;
import de.resolution.usersync.spi.AbstractOAuthConnectorConfiguration;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class AzureConnectorConfigurationImpl
extends AbstractOAuthConnectorConfiguration
implements AzureConnectorConfiguration {
    static final String DEFAULT_FIND_BY_ATTRIBUTE_NAME = "azure_ID";
    private static final String DEFAULT_AZURE_ENDPOINT = "https://login.microsoftonline.com";
    private static final String DEFAULT_GRAPH_ENDPOINT = "https://graph.microsoft.com";
    private static final AzureConnectorConfiguration.APIVersion DEFAULT_API_VERSION = AzureConnectorConfiguration.APIVersion.V1_0;
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();
    @Nonnull
    private String azureEndpoint = "https://login.microsoftonline.com";
    @Nonnull
    private String graphEndpoint = "https://graph.microsoft.com";
    @Nonnull
    private String directoryTenantId = "";
    @Nonnull
    private AzureConnectorConfiguration.APIVersion apiVersion = DEFAULT_API_VERSION;
    private boolean fetchGroupMemberships = false;
    private boolean fetchSecurityGroups = true;
    private boolean fetchMailEnabledSecurityGroups = true;
    private boolean fetchDistributionGroups = false;
    private boolean fetchOffice365GroupsSecurityEnabled = true;
    private boolean fetchOffice365GroupsNonSecurityEnabled = false;
    private boolean fetchManager = false;
    private boolean fetchProfilePicture = false;
    private String profilePictureSize = "96x96";
    @Nonnull
    private List<String> additionalAzureAttributes = new ArrayList<String>();
    private boolean isAddGroupOnPremisesSamAccountNameToUser = false;
    static final AttributeTransformationConfig ACTIVE_TRANSFORMATION = new AttributeTransformationConfig(Source.createSingle((String)"accountEnabled"), new Target(Target.Type.SYSTEM, "ATTR_ACTIVE"), false, true);

    public AzureConnectorConfigurationImpl() {
    }

    public AzureConnectorConfigurationImpl(AzureConnectorConfiguration other) {
        super(other);
        this.setAzureEndpoint(other.getAzureEndpoint());
        this.setGraphEndpoint(other.getGraphEndpoint());
        this.setDirectoryTenantId(other.getDirectoryTenantId());
        this.setApiVersion(other.getApiVersion());
        this.setFetchGroupMemberships(other.isFetchGroupMemberships());
        this.setFetchSecurityGroups(other.isFetchSecurityGroups());
        this.setFetchMailEnabledSecurityGroups(other.isFetchMailEnabledSecurityGroups());
        this.setFetchDistributionGroups(other.isFetchDistributionGroups());
        this.setFetchOffice365GroupsSecurityEnabled(other.isFetchOffice365GroupsSecurityEnabled());
        this.setFetchOffice365GroupsNonSecurityEnabled(other.isFetchOffice365GroupsNonSecurityEnabled());
        this.setFetchManager(other.isFetchManager());
        this.setFetchProfilePicture(other.isFetchProfilePicture());
        this.setAdditionalAzureAttributes(new ArrayList<String>(other.getAdditionalAzureAttributes()));
        this.setProfilePictureSize(other.getProfilePictureSize());
        this.setAddGroupOnPremisesSamAccountNameToUser(other.isAddGroupOnPremisesSamAccountNameToUser());
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return DEFAULT_FIND_BY_ATTRIBUTE_NAME;
    }

    @Override
    @Nonnull
    public ConnectorConfiguration sanitize() {
        AzureConnectorConfigurationImpl ret = new AzureConnectorConfigurationImpl(this);
        ret.setClientSecret("<<SENSITIVE DATA REMOVED>>");
        return ret;
    }

    @Override
    @Nonnull
    public String getAzureEndpoint() {
        return this.azureEndpoint;
    }

    public void setAzureEndpoint(@Nullable String azureEndpoint) {
        this.azureEndpoint = (String)Elvis.ifNull((Object)azureEndpoint, (Object)"");
    }

    @Override
    @Nonnull
    public String getGraphEndpoint() {
        return this.graphEndpoint;
    }

    public void setGraphEndpoint(@Nullable String graphEndpoint) {
        this.graphEndpoint = (String)Elvis.ifNull((Object)graphEndpoint, (Object)"");
    }

    @Override
    @Nonnull
    public String getDirectoryTenantId() {
        return this.directoryTenantId;
    }

    public void setDirectoryTenantId(@Nullable String directoryTenantId) {
        this.directoryTenantId = (String)Elvis.ifNull((Object)directoryTenantId, (Object)"");
    }

    @Override
    @Nonnull
    public AzureConnectorConfiguration.APIVersion getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(@Nullable AzureConnectorConfiguration.APIVersion apiVersion) {
        this.apiVersion = (AzureConnectorConfiguration.APIVersion)((Object)Elvis.ifNull((Object)((Object)apiVersion), (Object)((Object)DEFAULT_API_VERSION)));
    }

    @Override
    public boolean isFetchGroupMemberships() {
        return this.fetchGroupMemberships;
    }

    public void setFetchGroupMemberships(boolean fetchGroupMemberships) {
        this.fetchGroupMemberships = fetchGroupMemberships;
    }

    @Override
    public boolean isFetchSecurityGroups() {
        return this.fetchSecurityGroups;
    }

    public void setFetchSecurityGroups(boolean fetchSecurityGroups) {
        this.fetchSecurityGroups = fetchSecurityGroups;
    }

    @Override
    public boolean isFetchMailEnabledSecurityGroups() {
        return this.fetchMailEnabledSecurityGroups;
    }

    public void setFetchMailEnabledSecurityGroups(boolean fetchMailEnabledSecurityGroups) {
        this.fetchMailEnabledSecurityGroups = fetchMailEnabledSecurityGroups;
    }

    @Override
    public boolean isFetchDistributionGroups() {
        return this.fetchDistributionGroups;
    }

    public void setFetchDistributionGroups(boolean fetchDistributionGroups) {
        this.fetchDistributionGroups = fetchDistributionGroups;
    }

    @Override
    public boolean isFetchOffice365GroupsSecurityEnabled() {
        return this.fetchOffice365GroupsSecurityEnabled;
    }

    public void setFetchOffice365GroupsSecurityEnabled(boolean fetchOffice365GroupsSecurityEnabled) {
        this.fetchOffice365GroupsSecurityEnabled = fetchOffice365GroupsSecurityEnabled;
    }

    @Override
    public boolean isFetchOffice365GroupsNonSecurityEnabled() {
        return this.fetchOffice365GroupsNonSecurityEnabled;
    }

    public void setFetchManager(boolean fetchManager) {
        this.fetchManager = fetchManager;
    }

    @Override
    public boolean isFetchManager() {
        return this.fetchManager;
    }

    public void setFetchProfilePicture(boolean fetchProfilePicture) {
        this.fetchProfilePicture = fetchProfilePicture;
    }

    @Override
    public boolean isFetchProfilePicture() {
        return this.fetchProfilePicture;
    }

    @Override
    @Nonnull
    public String getProfilePictureSize() {
        return this.profilePictureSize;
    }

    public void setProfilePictureSize(String profilePictureSize) {
        this.profilePictureSize = profilePictureSize;
    }

    public void setFetchOffice365GroupsNonSecurityEnabled(boolean fetchOffice365GroupsNonSecurityEnabled) {
        this.fetchOffice365GroupsNonSecurityEnabled = fetchOffice365GroupsNonSecurityEnabled;
    }

    @Override
    @Nonnull
    public List<String> getAdditionalAzureAttributes() {
        return this.additionalAzureAttributes;
    }

    public void setAdditionalAzureAttributes(@Nullable List<String> additionalAzureAttributes) {
        this.additionalAzureAttributes = (List)Elvis.ifNull(additionalAzureAttributes, new ArrayList());
    }

    @Override
    @JsonIgnore
    public boolean isGroupSyncDisabled() {
        return !this.isFetchSecurityGroups() && !this.isFetchMailEnabledSecurityGroups() && !this.isFetchDistributionGroups() && !this.isFetchOffice365GroupsSecurityEnabled() && !this.isFetchOffice365GroupsNonSecurityEnabled();
    }

    @Override
    public boolean isAddGroupOnPremisesSamAccountNameToUser() {
        return this.isAddGroupOnPremisesSamAccountNameToUser;
    }

    public void setAddGroupOnPremisesSamAccountNameToUser(boolean addGroupOnPremisesSamAccountNameToUser) {
        this.isAddGroupOnPremisesSamAccountNameToUser = addGroupOnPremisesSamAccountNameToUser;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return AzureConnector.class;
    }

    static {
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"id"), new Target(Target.Type.CROWD, DEFAULT_FIND_BY_ATTRIBUTE_NAME), true, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"userPrincipalName"), new Target(Target.Type.SYSTEM, "ATTR_NAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"displayName"), new Target(Target.Type.SYSTEM, "ATTR_FULLNAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle((String)"userPrincipalName"), new Target(Target.Type.SYSTEM, "ATTR_EMAIL"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(ACTIVE_TRANSFORMATION);
        DEFAULT_TRANSFORMATION_CONFIGS.add(GROUP_TRANSFORMATION);
    }
}

