/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.AbstractSamlSsoService;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.cleanup.CleanupJobScheduler;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificator;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByRequestHeaderSelector;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHook;
import com.resolution.samlwrapper.api.ResponseIDStore;
import com.resolution.samlwrapper.api.SAMLWrapper;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Qualifier;

@ConfluenceComponent(value="samlSsoService")
@ExportAsService(value={SamlSsoService.class})
public class ConfluenceSamlSsoService
extends AbstractSamlSsoService {
    private final AuthenticatorHook authenticatorHook;

    @Inject
    public ConfluenceSamlSsoService(SAMLWrapper samlWrapper, @Qualifier(value="pluginConfiguration") RunningConfiguration pluginConfiguration, @ConfluenceImport ApplicationProperties applicationProperties, AuthenticatorHook authenticatorHook, @Qualifier(value="clusterNotificator") ClusterNotificator clusterNotificator, @ConfluenceImport TemplateRenderer templateRenderer, ResponseIDStore responseIdStore, AuthenticationTrackerRepository authenticationTrackerRepository, IdpByRequestHeaderSelector idpByRequestHeaderSelector, CleanupJobScheduler cleanupJobScheduler) {
        super(samlWrapper, pluginConfiguration, applicationProperties, clusterNotificator, templateRenderer, responseIdStore, authenticationTrackerRepository, idpByRequestHeaderSelector, cleanupJobScheduler);
        this.authenticatorHook = authenticatorHook;
    }

    @Override
    public String getRelativeNossoLoginPageUrl() {
        return this.getRelativeBaseUrl() + this.getRelativeDefaultLoginPageUrl() + "?nosso";
    }

    @Override
    protected String getRelativeDefaultLoginPageUrl() {
        return "/login.action";
    }

    @Override
    public String getRelativeRedirectUrlForLogout(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath.equals(this.getRelativeDefaultLoginPageUrl()) && request.getParameter("logout") != null && request.getParameter("logout").equals("true")) {
            return this.getRelativeBaseUrl() + "/plugins/servlet/samlsso/logout";
        }
        if (servletPath.equals("/logout.action")) {
            return this.getRelativeBaseUrl() + "/plugins/servlet/samlsso/logout";
        }
        return null;
    }

    @Override
    public boolean isLoggedInUser(HttpServletRequest httpServletRequest) {
        return this.authenticatorHook.isLoggedInUser(httpServletRequest);
    }

    @Override
    public boolean isConfluence() {
        return true;
    }
}

