/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim;

import java.util.Objects;
import javax.annotation.Nonnull;

public class UserOrGroupRef {
    @Nonnull
    private final String id;
    @Nonnull
    private final Type type;

    private UserOrGroupRef(@Nonnull String id, @Nonnull Type type) {
        this.id = id;
        this.type = type;
    }

    @Nonnull
    public static UserOrGroupRef createUserRef(@Nonnull String id) {
        return new UserOrGroupRef(id, Type.USER);
    }

    @Nonnull
    public static UserOrGroupRef createGroupRef(@Nonnull String id) {
        return new UserOrGroupRef(id, Type.GROUP);
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UserOrGroupRef other = (UserOrGroupRef)obj;
        return this.type == other.type && Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type});
    }

    static enum Type {
        USER("User"),
        GROUP("Group");

        @Nonnull
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @Nonnull
        public String getValue() {
            return this.value;
        }
    }
}

