/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import com.atlassian.sal.api.user.UserProfile;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.WebSudoRequiredException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface PrivilegeChecker {
    public UserProfile checkPrivileges(HttpServletRequest var1, Predicate<UserProfile> var2) throws InsufficientUserPrivilegeException;

    public void requireWebSudo(boolean var1, HttpServletRequest var2, HttpServletResponse var3) throws WebSudoRequiredException;

    public PrivilegeFactory getPrivilegeFactory();

    public void checkAdmin(HttpServletRequest var1) throws InsufficientUserPrivilegeException;

    public void checkSysAdmin(HttpServletRequest var1) throws InsufficientUserPrivilegeException;

    public void checkUser(HttpServletRequest var1) throws InsufficientUserPrivilegeException;

    public static interface PrivilegeFactory {
        public Privilege deny();

        public Privilege isSysadmin();

        public Privilege isAdmin();

        public Privilege isUser();

        public Privilege isInGroup(List<String> var1);

        default public Privilege isInGroup(String group) {
            return this.isInGroup(Collections.singletonList(group));
        }

        public Privilege hasUserKey(List<String> var1);

        default public Privilege hasUserKey(String userKey) {
            return this.hasUserKey(Collections.singletonList(userKey));
        }

        public Privilege isAnonymous();
    }

    public static interface Privilege
    extends Predicate<UserProfile> {
    }

    public static enum AccessMode {
        READ,
        WRITE,
        WRITE_IN_READ_ONLY_MODE,
        VALIDATE,
        READ_PRIVILEGED,
        READ_ANALYTICS;

    }
}

