/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import de.resolution.atlasuser.api.group.AtlasGroupResult;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.Tuple;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.builtin.scim.exception.ScimExceptionWrapper;
import de.resolution.usersync.builtin.scim.group.ScimCoreGroup;
import de.resolution.usersync.builtin.scim.rest.AbstractResource;
import de.resolution.usersync.builtin.scim.rest.ListResponse;
import de.resolution.usersync.builtin.scim.rest.PATCH;
import de.resolution.usersync.builtin.scim.rest.PatchRequest;
import de.resolution.usersync.builtin.scim.rest.ScimRequestUtils;
import groovy.lang.Script;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="usersync/connector/{connectorId}/scim/v2/Groups")
@AnonymousAllowed
@UnrestrictedAccess
public class GroupResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GroupResource.class);
    private static final String MESSAGE_GROUPID_MUST_NOT_BE_EMPTY = "GroupId must not be empty";
    private static final Script COLLECT_VALUE_EXPRESSION = StructuredData.prepareFind((String)"value.collect{it}");
    private static final Script VALUE_EXPRESSION = StructuredData.prepareFind((String)"value");
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Inject
    public GroupResource(@Nonnull ConnectorService connectorService, @Nonnull PrivilegeChecker privilegeChecker, @Nonnull LicenseChecker licenseChecker, @Nonnull SyncStatusRepository syncStatusRepository) {
        super(connectorService, privilegeChecker, licenseChecker, syncStatusRepository);
    }

    @Nonnull
    private Response logAndReturnResponse(@Nonnull Tuple<ScimCoreGroup, AtlasGroupResult.Operation> result, @Nonnull SyncStatusFacade syncStatusFacade) {
        Response.Status status = GroupResource.operationToStatus((AtlasGroupResult.Operation)result.right());
        syncStatusFacade.add("<-- Response: " + JSONUtil.asJson((Object)status), SyncStatusFacade.LogLevel.DEBUG, logger);
        String responseBody = JSONUtil.asJson((Object)result.left());
        if (logger.isDebugEnabled()) {
            syncStatusFacade.add(responseBody, SyncStatusFacade.LogLevel.DEBUG, logger);
        }
        if (syncStatusFacade.getSyncStatus() != null && syncStatusFacade.getSyncStatus().getSyncStatusResult() != SyncStatus.Result.FAILED && syncStatusFacade.getSyncStatus().getSyncStatusResult() != SyncStatus.Result.PARTIALLY_FAILED) {
            syncStatusFacade.getSyncStatus().setSyncStatusResult(SyncStatus.Result.SUCCESS);
        }
        return Response.status((Response.Status)status).entity((Object)responseBody).build();
    }

    @Nonnull
    protected static Response.Status operationToStatus(@Nonnull AtlasGroupResult.Operation operation) {
        switch (operation) {
            case ADDED: {
                return Response.Status.CREATED;
            }
            case MEMBER_ADDED: 
            case MEMBER_REMOVED: 
            case UPDATED: {
                return Response.Status.OK;
            }
            case FILTERED: 
            case DELETED: {
                return Response.Status.NO_CONTENT;
            }
            case NOT_MODIFIED: {
                return Response.Status.NOT_MODIFIED;
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    @GET
    @Produces(value={"application/json", "application/scim+json"})
    public Response getGroups(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @QueryParam(value="startIndex") int startIndex, @QueryParam(value="count") int count, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @QueryParam(value="filter") @Nullable String filter) throws ScimExceptionWrapper {
        return this.handleScimRequest(request, connectorId, false, (scimConnector, syncStatusFacade) -> {
            if (logger.isTraceEnabled()) {
                logger.trace("--> GET /Groups/ - startIndex: {}, count: {}, filter: {}", new Object[]{startIndex, count, filter});
            }
            ListResponse listResponse = scimConnector.getDirectoryGroups(ScimRequestUtils.parseStartIndex(startIndex), ScimRequestUtils.parseCount(count), ScimRequestUtils.parseFilter(filter), ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            if (logger.isTraceEnabled()) {
                logger.trace("Returned {} groups", (Object)listResponse.getResources().size());
            }
            return Response.ok((Object)JSONUtil.asJson((Object)listResponse)).build();
        });
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/scim+json"})
    public Response getGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="id") @Nullable String groupName, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes) throws ScimExceptionWrapper {
        return this.handleScimRequest(request, connectorId, false, (scimConnector, syncStatusFacade) -> {
            if (groupName == null || groupName.isEmpty()) {
                throw BadRequestException.noTarget((String)MESSAGE_GROUPID_MUST_NOT_BE_EMPTY);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("--> GET /Groups/{} ", (Object)StringUtil.sanitize((String)groupName));
            }
            ScimCoreGroup scimGroup = scimConnector.getDirectoryGroup(groupName, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            if (logger.isTraceEnabled()) {
                logger.trace("Returned group with id {}", (Object)StringUtil.sanitize((String)groupName));
            }
            return Response.ok((Object)JSONUtil.asJson((Object)scimGroup)).build();
        });
    }

    @POST
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response createGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, String resourceString) throws ScimExceptionWrapper {
        return this.handleScimRequest(request, connectorId, (scimConnector, syncStatusFacade) -> {
            if (StringUtil.isNullOrEmpty((String)resourceString)) {
                throw BadRequestException.invalidValue((String)"Request contains no resource string");
            }
            syncStatusFacade.add(LocalDateTime.now().format(this.formatter) + " --> POST /Groups/", SyncStatusFacade.LogLevel.DEBUG, logger);
            if (logger.isDebugEnabled()) {
                syncStatusFacade.add(resourceString, SyncStatusFacade.LogLevel.DEBUG, logger);
            }
            StructuredData data = StructuredData.parseJson((String)resourceString);
            Tuple<ScimCoreGroup, AtlasGroupResult.Operation> result = scimConnector.createOrUpdateDirectoryGroup(data, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            return this.logAndReturnResponse(result, syncStatusFacade);
        });
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response updateGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="id") @Nullable String groupId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, String resourceString) throws ScimExceptionWrapper {
        return this.handleScimRequest(request, connectorId, (scimConnector, syncStatusFacade) -> {
            if (groupId == null || groupId.isEmpty()) {
                throw BadRequestException.noTarget((String)MESSAGE_GROUPID_MUST_NOT_BE_EMPTY);
            }
            if (StringUtil.isNullOrEmpty((String)resourceString)) {
                throw BadRequestException.invalidValue((String)"Request contains no resource string");
            }
            syncStatusFacade.add(LocalDateTime.now().format(this.formatter) + " --> PUT /Groups/" + groupId, SyncStatusFacade.LogLevel.DEBUG, logger);
            if (logger.isDebugEnabled()) {
                syncStatusFacade.add(resourceString, SyncStatusFacade.LogLevel.DEBUG, logger);
            }
            StructuredData data = StructuredData.parseJson((String)resourceString);
            Tuple<ScimCoreGroup, AtlasGroupResult.Operation> result = scimConnector.updateDirectoryGroup(groupId, data, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            return this.logAndReturnResponse(result, syncStatusFacade);
        });
    }

    @PATCH
    @Path(value="{id}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response patchGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="id") @Nullable String groupName, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @Nullable String resourceString) throws ScimExceptionWrapper {
        return this.handleScimRequest(request, connectorId, (scimConnector, syncStatusFacade) -> {
            PatchRequest patchRequest;
            if (StringUtil.isNullOrEmpty((String)groupName)) {
                throw BadRequestException.noTarget((String)MESSAGE_GROUPID_MUST_NOT_BE_EMPTY);
            }
            if (StringUtil.isNullOrEmpty((String)resourceString)) {
                throw BadRequestException.invalidValue((String)"PATCH request did not contain any PATCH operations");
            }
            syncStatusFacade.add(LocalDateTime.now().format(this.formatter) + " --> PATCH /Groups/" + groupName, SyncStatusFacade.LogLevel.DEBUG, logger);
            if (logger.isDebugEnabled()) {
                syncStatusFacade.add(resourceString, SyncStatusFacade.LogLevel.DEBUG, logger);
            }
            if ((patchRequest = PatchRequest.fromJson(resourceString)).getOperations().stream().anyMatch(operation -> "displayName".equalsIgnoreCase(operation.getPath()))) {
                throw BadRequestException.mutability((String)"Renaming a group is not allowed");
            }
            block5: for (PatchRequest.PatchOperation operation2 : patchRequest.getOperations()) {
                StructuredData foundValues;
                if (!"members".equalsIgnoreCase(operation2.getPath())) continue;
                List<Object> memberIds = operation2.getValue().isList() ? ((foundValues = operation2.getValue().find(COLLECT_VALUE_EXPRESSION)) != null && foundValues.isList() ? foundValues.asStringList() : Collections.emptyList()) : Collections.singletonList(operation2.getValue().findString(VALUE_EXPRESSION));
                switch (operation2.getOp()) {
                    case ADD: {
                        scimConnector.addMemberIdsToGroup((Collection<String>)memberIds, groupName, syncStatusFacade);
                        continue block5;
                    }
                    case REPLACE: {
                        scimConnector.setMemberIdsForGroup(new HashSet<String>(memberIds), groupName, syncStatusFacade);
                        continue block5;
                    }
                    case REMOVE: {
                        scimConnector.removeMemberIdsFromGroup((Collection<String>)memberIds, groupName, syncStatusFacade);
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)operation2.getOp()));
            }
            ScimCoreGroup updatedGroup = scimConnector.getDirectoryGroup(groupName, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes), syncStatusFacade);
            return this.logAndReturnResponse((Tuple<ScimCoreGroup, AtlasGroupResult.Operation>)new Tuple((Object)updatedGroup, (Object)AtlasGroupResult.Operation.UPDATED), syncStatusFacade);
        });
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/scim+json"})
    public Response deleteGroup(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="id") @Nullable String groupName) throws ScimExceptionWrapper {
        return this.handleScimRequest(request, connectorId, (scimConnector, syncStatusFacade) -> {
            if (groupName == null || groupName.isEmpty()) {
                throw BadRequestException.noTarget((String)MESSAGE_GROUPID_MUST_NOT_BE_EMPTY);
            }
            syncStatusFacade.add(LocalDateTime.now().format(this.formatter) + " --> DELETE /Groups/" + groupName, SyncStatusFacade.LogLevel.DEBUG, logger);
            scimConnector.deleteDirectoryGroup(groupName, syncStatusFacade);
            return Response.noContent().build();
        });
    }

    @POST
    @Path(value="/.search")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response getGroupsByPost() throws ScimExceptionWrapper {
        throw new ScimExceptionWrapper((ScimException)new NotImplementedException("This endpoint is not implemented"), null);
    }
}

