/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNameExistsAlreadyException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidOperationException;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorFactoryRegistry;
import de.resolution.usersync.api.ConnectorStorageManager;
import de.resolution.usersync.api.IdentifierForSingleUserSync;
import de.resolution.usersync.api.LabelValue;
import de.resolution.usersync.api.NotificationService;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.impl.DirectoryIdAndName;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ConnectorService {
    public static final String CONNECTOR_UID_KEY = "CONNECTOR_UID";
    public static final String SYNCSTATUS_ID_KEY = "SYNCSTATUS_ID";

    @Nonnull
    public <K extends ConnectorConfiguration, C extends Connector<K>> C create(@Nonnull String var1) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    @Nonnull
    public <K extends ConnectorConfiguration> Connector<K> create(@Nonnull Class<? extends Connector<K>> var1) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    @Nonnull
    public <K extends ConnectorConfiguration, C extends Connector<K>> C createWithConfiguration(@Nonnull String var1) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    @Nonnull
    public ValidationResult validateIdentifierForSingleSync(@Nonnull IdentifierForSingleUserSync var1, @Nonnull String var2);

    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> configure(@Nonnull String var1, @Nonnull String var2) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> configure(@Nonnull String var1, @Nonnull K var2) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    public boolean connectorExists(@Nullable String var1);

    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> getConnectorByUniqueId(@Nonnull String var1) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> Collection<ConnectorAndValidationResult<C, K>> getConnectors();

    @Nonnull
    public <C extends Connector<K>, K extends ConnectorConfiguration> ConnectorAndValidationResult<C, K> reloadConnectorIntoCache(@Nonnull String var1) throws ConnectorNotFoundException, ConnectorFactoryNotAvailableException, ConfigurationFailedException;

    public void toggleSchedule(@Nonnull Connector<?> var1);

    @Nonnull
    public <K extends ConnectorConfiguration> ValidationResult validate(@Nonnull Connector<K> var1);

    public boolean delete(@Nonnull String var1);

    public String createNewUniqueId();

    public boolean directoryExists(long var1);

    public long createDirectory(@Nonnull String var1, @Nonnull String var2) throws DirectoryNameExistsAlreadyException;

    public void renameDirectory(long var1, @Nonnull String var3, @Nonnull String var4) throws DirectoryNameExistsAlreadyException, DirectoryNotFoundException, InvalidOperationException;

    @Nonnull
    public List<AtlasUserDirectory> getOrphanedDirectories();

    public void deleteOrphanedDirectory(long var1) throws InvalidOperationException, DirectoryNotFoundException, AtlasUserOperationFailedException;

    @Nonnull
    public List<LabelValue<String, String>> getAvailableConnectorNamesAndUniqueIds();

    @Nullable
    public String getConnectorUIDforLegacyId(int var1);

    public long getFirstWritableDirectoryId();

    @Nonnull
    public List<AtlasUserDirectory> getAllDirectories();

    @Nonnull
    public ConnectorStorageManager getConnectorStorageManager();

    @Nonnull
    public DirectoryIdAndName prepareDirectory(long var1, @Nonnull String var3, @Nonnull String var4) throws InvalidOperationException;

    @Nonnull
    public String makeDirectoryNameUnique(@Nonnull String var1) throws InvalidOperationException;

    @Nonnull
    public String getApplicationPrefix();

    @Nonnull
    public String getBaseUrl();

    public boolean isInitialized();

    public void initUserSyncConnectors();

    @Nonnull
    public AtlasUserAdapter getAtlasUserAdapter();

    @Nonnull
    public NotificationService getNotificationService();

    @Nonnull
    public ConnectorFactoryRegistry getConnectorFactoryRegistry();

    @Nonnull
    public AttributeTransformationConfigValidator getAttributeTransformationConfigValidator();

    @Nonnull
    public Map<String, String> fetchRequiredConnectorGroups(@Nonnull String var1, @Nonnull RequiredGroupCheckerHolder var2) throws ConnectorFactoryNotAvailableException, ConfigurationFailedException, ConnectorNotFoundException, GeneralSyncException;
}

