/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.cronexpressionrest;

import de.resolution.reconfigure.cronexpressionrest.CronExpression;
import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import java.time.ZonedDateTime;
import org.springframework.stereotype.Component;

@Component
public class StandaloneCronExpressionValidator
implements CronExpressionValidator {
    @Override
    public boolean isValid(String cronExpression) {
        try {
            CronExpression.create(cronExpression);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public long getNextScheduledSyncAsLong(String cronString) {
        try {
            CronExpression cronExpression = CronExpression.create(cronString);
            ZonedDateTime next = cronExpression.nextTimeAfter(ZonedDateTime.now());
            return next.toInstant().toEpochMilli();
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }
}

