/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class CaffeineCachedJwkProvider
implements JwkProvider {
    private final Cache<String, Jwk> cache;
    private final JwkProvider provider;
    static final String NULL_KID_KEY = "null-kid";

    public CaffeineCachedJwkProvider(JwkProvider provider) {
        this(provider, 5L, Duration.ofMinutes(10L));
    }

    public CaffeineCachedJwkProvider(JwkProvider provider, long size, long expiresIn, TimeUnit expiresUnit) {
        this.provider = provider;
        this.cache = Caffeine.newBuilder().maximumSize(size).expireAfterWrite(expiresIn, expiresUnit).build();
    }

    public CaffeineCachedJwkProvider(JwkProvider provider, long size, Duration expiresIn) {
        this(provider, size, expiresIn.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Jwk get(String keyId) throws JwkException {
        try {
            String cacheKey = keyId == null ? NULL_KID_KEY : keyId;
            return (Jwk)this.cache.get((Object)cacheKey, key -> {
                try {
                    return this.provider.get(key);
                }
                catch (JwkException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof JwkException) {
                throw (JwkException)e.getCause();
            }
            throw new JwkException("Unable to obtain key with kid " + keyId, (Throwable)e);
        }
    }

    JwkProvider getBaseProvider() {
        return this.provider;
    }
}

