(function () {

    var timeoutForLastIdP;

    AJS.toInit(function () {
        // Hide these items
        AJS.$('#notFound').hide();
        AJS.$('#redirecting').hide();

        // The form is never submitted
        AJS.$("#emailAddressForm").submit(function (e) {
            e.preventDefault();
        });

        AJS.$("#emailAddressField").on('input', function (e) {
            checkEmailField();
        });

        console.log("lastidp is " + lastidp + " timeout is " + redirectTimeout);
        console.log("last url is " + lastSsourl);

        if(lastidp !== 0 && redirectTimeout > 0) {
            console.log('Setting timeout to ' + redirectTimeout);
            timeoutForLastIdP = setTimeout(function() { location.href = lastSsourl } , redirectTimeout);
        }
    });

    function checkEmailField() {
        AJS.$('#notFound').hide();
        AJS.$('#redirecting').hide();
        AJS.$('#waitForRedirect').hide();

        console.log('Clearing Timeout');
        clearTimeout(timeoutForLastIdP);

        // The input must have an @ and a . behind it to be ready to be checked
        var addressPattern = new RegExp(".*@.*\\...+");
        var enteredEmail = AJS.$("#emailAddressField").val();
        if (!addressPattern.test(enteredEmail)) {
            return;
        }
        var atPosition = enteredEmail.indexOf('@');
        if (atPosition < 0) {
            return;
        }
        var emailDomain = enteredEmail.substring(atPosition + 1).toLowerCase();
        if (!emailDomain) {
            return;
        }

        var restEndpointUrl = emailDomains.__emailDomainCheck;
        AJS.$.ajax({
            url: restEndpointUrl + emailDomain,
            dataType: "json",
            success: function (data) {
                console.log("Successfully retrieved IdP for given email domain", data);
                var idpId = data.idpId;
                if (idpId !== 0) {
                    AJS.$('#notFound').hide();
                    AJS.$('#redirecting').show();
                    AJS.$('#emailAddressField').prop('disabled', true);

                    redirectUrl = ssoURL.replace('IDPID', idpId).replace('LOGINHINT', enteredEmail);
                    // This avoids a warning message when starting the redirect
                    window.onbeforeunload = function () {
                    };
                    window.location = redirectUrl;
                } else {
                    AJS.$('#notFound').show();
                }
            },
            error: function (xhr, errorText, err) {
                console.error("Error checking email domain: " + errorText, err);
                AJS.$('#notFound').show();
            }
        });
    }
})();
