/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class MemoryInfo {
    private final long total;
    private final long max;
    private final long free;
    private final long timestamp;
    private final String timestampString;

    public static MemoryInfo create() {
        return new MemoryInfo();
    }

    public static String asString() {
        return MemoryInfo.create().toString();
    }

    private MemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        this.free = runtime.freeMemory();
        this.total = runtime.totalMemory();
        this.max = runtime.maxMemory();
        this.timestamp = System.currentTimeMillis();
        this.timestampString = new SimpleDateFormat("HH:mm:ss").format(this.timestamp);
    }

    public long getTotal() {
        return this.total;
    }

    public long getMax() {
        return this.max;
    }

    public long getFree() {
        return this.free;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampString() {
        return this.timestampString;
    }

    public String toString() {
        return this.getTimestampString() + ": max: " + MemoryInfo.readableSize(this.getMax()) + " total: " + MemoryInfo.readableSize(this.getTotal()) + " free: " + MemoryInfo.readableSize(this.getFree());
    }

    public static String readableSize(long bytes) {
        if (bytes <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(bytes) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)bytes / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }
}

