/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.usersync.util.UserSyncUtils;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect
public class AtlasUserResultEntity {
    private final ExceptionInfo exceptionInfo;
    private final AtlasUser resultingUser;
    private final AtlasUser initialUser;
    private final AtlasUser inputUser;
    private final String operation;
    private final String modified;
    private final List<String> messages;
    private final String errorType;
    private final String success;
    private final AtlasUserResultEntity removeFromOtherResult;

    public AtlasUserResultEntity(AtlasUserResult result) {
        this.operation = result.getOperation().name();
        this.resultingUser = result.getResultingUser().orElse(null);
        this.initialUser = result.getInitialUser().orElse(null);
        this.inputUser = result.getInputUser().orElse(null);
        this.success = String.valueOf(UserSyncUtils.checkSuccess(result));
        this.modified = String.valueOf(result.isModified());
        this.exceptionInfo = result.getExceptionInfo().orElse(null);
        this.messages = result.getMessages().orElse(null);
        this.errorType = result.getErrorType().name();
        this.removeFromOtherResult = result.getRemoveInOtherResult().map(AtlasUserResultEntity::new).orElse(null);
    }

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public AtlasUser getResultingUser() {
        return this.resultingUser;
    }

    public AtlasUser getInitialUser() {
        return this.initialUser;
    }

    public AtlasUser getInputUser() {
        return this.inputUser;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getModified() {
        return this.modified;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getSuccess() {
        return this.success;
    }

    public AtlasUserResultEntity getRemoveFromOtherResult() {
        return this.removeFromOtherResult;
    }
}

